/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.api;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.EconomyUse;
import com.kingpixel.cobbleutils.api.EconomyApi;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.command.CommandTree;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.database.DataBaseFactory;
import com.kingpixel.ultrashop.migrate.OldShop;
import com.kingpixel.ultrashop.models.ActionShop;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.SubShop;
import com.mojang.brigadier.CommandDispatcher;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class ShopApi {
    public static Map<String, Config> configs = new HashMap<String, Config>();
    public static Map<String, List<Shop>> shops = new HashMap<String, List<Shop>>();
    public static Map<Shop, List<Product>> sellProducts = new HashMap<Shop, List<Product>>();
    public static final Map<UUID, Long> sellLock = new HashMap<UUID, Long>();

    public static void register(ShopOptionsApi options, CommandDispatcher<class_2168> dispatcher) {
        OldShop.migration();
        Config config = new Config().readConfig(options);
        configs.put(options.getModId(), config);
        options.setCommands(config.getCommands());
        Config.readShops(options);
        CommandTree.register(options, dispatcher);
        UltraShop.initSellProduct(options);
        Config main = configs.get("ultrashop");
        if (main == null) {
            return;
        }
        UltraShop.lang.init(main);
    }

    public static List<Shop> getShops(ShopOptionsApi options) {
        return shops.get(options.getModId());
    }

    public static List<Shop> getShops(List<SubShop> subShops) {
        return shops.get("ultrashop").stream().filter(shop -> subShops.stream().anyMatch(subShop -> subShop.getIdShop().equals(shop.getId()))).toList();
    }

    public static Shop getShop(ShopOptionsApi options, String id) {
        List<Shop> s = shops.get(options.getModId());
        for (Shop shop : s) {
            if (!shop.getId().equals(id)) continue;
            return shop;
        }
        return null;
    }

    public static Config getConfig(ShopOptionsApi options) {
        return configs.get(options.getModId());
    }

    public static void sellAll(class_3222 player, List<class_1799> itemStacks, ShopOptionsApi options) {
        CompletableFuture.runAsync(() -> {
            if (itemStacks.isEmpty()) {
                return;
            }
            if (sellLock.containsKey(player.method_5667())) {
                return;
            }
            sellLock.put(player.method_5667(), System.currentTimeMillis());
            long start = System.currentTimeMillis();
            Map dataSell = itemStacks.stream().flatMap(itemStack -> sellProducts.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().filter(product -> product.canSell(player, (Shop)entry.getKey(), options)).map(product -> {
                BigDecimal sellPrice = Product.sellProduct((Shop)entry.getKey(), itemStack, product);
                if (sellPrice.compareTo(BigDecimal.ZERO) > 0) {
                    int amount = itemStack.method_7947();
                    DataBaseFactory.INSTANCE.addTransaction(player, (Shop)entry.getKey(), (Product)product, ActionShop.SELL, amount, product.getSellPrice(amount));
                }
                return Map.entry(((Shop)entry.getKey()).getEconomy(), sellPrice);
            }).filter(e -> ((BigDecimal)e.getValue()).compareTo(BigDecimal.ZERO) > 0))).collect(HashMap::new, (map, entry) -> map.merge((EconomyUse)entry.getKey(), (BigDecimal)entry.getValue(), BigDecimal::add), HashMap::putAll);
            if (!dataSell.isEmpty()) {
                StringBuilder allSell = new StringBuilder();
                dataSell.forEach((economyUse, price) -> {
                    allSell.append(UltraShop.lang.getFormatSell().replace("%price%", EconomyApi.formatMoney((BigDecimal)price, (EconomyUse)economyUse))).append("\n");
                    EconomyApi.addMoney((UUID)player.method_5667(), (BigDecimal)price, (EconomyUse)economyUse);
                });
                PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageSell().replace("%sell%", allSell.toString()), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
            } else {
                PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotSell(), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
            }
            if (ShopApi.getMainConfig().isDebug()) {
                long duration = System.currentTimeMillis() - start;
                CobbleUtils.LOGGER.info("ultrashop", "Sell took " + duration + "ms");
            }
            sellLock.remove(player.method_5667());
        }, UltraShop.SHOP_EXECUTOR).exceptionally(e -> {
            CobbleUtils.LOGGER.error("ultrashop", "Error selling items -> " + String.valueOf(e));
            sellLock.remove(player.method_5667());
            return null;
        });
    }

    public static Config getMainConfig() {
        return ShopApi.getConfig(ShopOptionsApi.builder().modId("ultrashop").build());
    }
}

