/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.command;

import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.gui.edit.MenuEdit;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CommandTree {
    public static void register(ShopOptionsApi options, CommandDispatcher<class_2168> dispatcher) {
        for (String command : options.getCommands()) {
            LiteralArgumentBuilder base = options.getModId().equals("ultrashop") ? CommandTree.build((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)command), options) : (LiteralArgumentBuilder)class_2170.method_9247((String)command).then(CommandTree.build((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"shop"), options));
            dispatcher.register(base);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sell").requires(source -> PermissionApi.hasPermission((class_2168)source, (String)"ultrashop.sell.base", (int)4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"hand").executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            class_1661 inventory = player.method_31548();
            if (inventory == null) {
                return 0;
            }
            ShopApi.sellAll(((class_2168)context.getSource()).method_44023(), List.of(inventory.method_7391()), options);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionApi.hasPermission((class_2168)source, (String)"ultrashop.sell.other", (int)4))).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ShopApi.sellAll(player, List.of(player.method_6047()), options);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            class_1661 inventory = player.method_31548();
            if (inventory == null) {
                return 0;
            }
            ShopApi.sellAll(((class_2168)context.getSource()).method_44023(), (List<class_1799>)inventory.field_7547, options);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionApi.hasPermission((class_2168)source, (String)"ultrashop.sell.other", (int)4))).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ShopApi.sellAll(player, (List<class_1799>)player.method_31548().field_7547, options);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<class_2168> build(LiteralArgumentBuilder<class_2168> base, ShopOptionsApi options) {
        String modId = options.getModId().equals("ultrashop") ? "ultrashop" : options.getModId() + ".shop";
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.requires(source -> PermissionApi.hasPermission((class_2168)source, List.of(modId + ".base", modId + ".admin"), (int)2))).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            ShopApi.getConfig(options).open(((class_2168)context.getSource()).method_44023(), options);
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionApi.hasPermission((class_2168)source, List.of(modId + ".reload", modId + ".admin"), (int)2))).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            UltraShop.load(options);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Reloaded " + options.getModId() + " shops")));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"other").requires(source -> PermissionApi.hasPermission((class_2168)source, List.of(modId + ".other", modId + ".admin"), (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"player");
            if (players.isEmpty()) {
                return 0;
            }
            Config config = ShopApi.getConfig(options);
            for (class_3222 player : players) {
                config.open(player, options);
            }
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"IdShop", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (Shop shop : ShopApi.getShops(options)) {
                builder.suggest(shop.getId());
            }
            return builder.buildFuture();
        }).executes(context -> {
            CommandTree.openShop((CommandContext<class_2168>)context, options, true);
            return 1;
        })).then(class_2170.method_9244((String)"WithClose", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean withClose = BoolArgumentType.getBool((CommandContext)context, (String)"WithClose");
            CommandTree.openShop((CommandContext<class_2168>)context, options, withClose);
            return 1;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").requires(source -> PermissionApi.hasPermission((class_2168)source, List.of(modId + ".edit", modId + ".admin"), (int)4))).then(class_2170.method_9244((String)"shop", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            for (Shop shop : ShopApi.getShops(options)) {
                suggestionsBuilder.suggest(shop.getId());
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            String idShop = StringArgumentType.getString((CommandContext)context, (String)"shop");
            Shop shop = ShopApi.getShop(options, idShop);
            if (shop == null) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"This command is in development, please configure it in the json file"), false);
            MenuEdit.open(((class_2168)context.getSource()).method_44023(), shop, options);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(source -> PermissionApi.hasPermission((class_2168)source, List.of(modId + ".create", modId + ".admin"), (int)2))).then(class_2170.method_9244((String)"shop", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            for (TypeShop value : TypeShop.values()) {
                suggestionsBuilder.suggest(value.name());
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            String id = StringArgumentType.getString((CommandContext)context, (String)"shop");
            boolean exist = ShopApi.getShops(options).stream().anyMatch(shop -> shop.getId().equals(id));
            if (exist) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"The shop already exists"));
                return 0;
            }
            Shop shop2 = new Shop(id, new ShopTypePermanent());
            shop2.setType(ShopType.get(StringArgumentType.getString((CommandContext)context, (String)"type")));
            ShopApi.getConfig(options).createShop(options, shop2);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"restartShop").requires(context -> PermissionApi.hasPermission((class_2168)context, (String)(modId + ".restart.shop"), (int)4))).then(class_2170.method_9244((String)"shop", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            List<Shop> shops = ShopApi.getShops(options);
            for (Shop shop : shops) {
                TypeShop type = shop.getType().getTypeShop();
                if (type != TypeShop.DYNAMIC && type != TypeShop.DYNAMIC_WEEKLY && type != TypeShop.DYNAMIC_CALENDAR) continue;
                suggestionsBuilder.suggest(shop.getId());
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            String shopId = StringArgumentType.getString((CommandContext)context, (String)"shop");
            Shop shop = ShopApi.getShop(options, shopId);
            ShopType type = shop.getType();
            switch (type.getTypeShop()) {
                case DYNAMIC: 
                case DYNAMIC_WEEKLY: 
                case DYNAMIC_CALENDAR: {
                    UltraShop.dataShop.updateDynamicProducts(shop, options);
                    break;
                }
                default: {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"This shop is not dynamic, please use the command /shop reload"));
                }
            }
            return 1;
        })));
        return base;
    }

    private static void openShop(CommandContext<class_2168> context, ShopOptionsApi options, boolean withClose) {
        try {
            Collection players = class_2186.method_9312(context, (String)"player");
            String s = StringArgumentType.getString(context, (String)"IdShop");
            Config config = ShopApi.getConfig(options);
            Shop shop = ShopApi.getShop(options, s);
            if (shop == null) {
                for (class_3222 player : players) {
                    PlayerUtils.sendMessage((class_3222)player, (String)("The shop with id " + s + " does not exist"), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                }
            } else {
                Stack<Shop> stack = new Stack<Shop>();
                stack.push(shop);
                for (class_3222 player : players) {
                    shop.open(player, options, config, 0, stack, withClose);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

