/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.config;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.Model.ItemModel;
import com.kingpixel.cobbleutils.Model.PanelsConfig;
import com.kingpixel.cobbleutils.Model.Sound;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.cobbleutils.util.UIUtils;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopTypeCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicWeekly;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.adapters.ShopTypeWeekly;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.SubShop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.class_3222;

public class Config {
    private String Path;
    private boolean debug = false;
    private boolean saveTransactions = true;
    private String lang = "en";
    private int rows = 6;
    private String title = "Shop";
    private String soundOpen = "";
    private String soundClose = "";
    private DataBaseConfig dataBase;
    private Map<String, Float> discounts = new HashMap<String, Float>();
    private ItemModel itemClose;
    private List<String> commands;
    private List<PanelsConfig> panels;

    public Config() {
        this.discounts.put("group.vip", Float.valueOf(2.0f));
        this.dataBase = new DataBaseConfig();
        this.dataBase.setDatabase("ultrashop");
        this.itemClose = new ItemModel(Integer.valueOf(49), "minecraft:barrier", "&cClose", List.of(), 0);
        this.commands = new ArrayList<String>();
        this.commands.add("shop");
        this.panels = List.of(new PanelsConfig(new ItemModel("minecraft:gray_stained_glass_pane"), this.rows));
    }

    public Config readConfig(ShopOptionsApi options) {
        boolean read;
        AtomicReference<Config> config = new AtomicReference<Config>();
        String path = options.getPath();
        File folder = Utils.getAbsolutePath((String)path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(read = Utils.readFileSync((File)Utils.getAbsolutePath((String)(options.getPath() + "config.json")), call -> {
            config.set((Config)UltraShop.gson.fromJson(call, Config.class));
            this.write((Config)config.get(), options);
        }))) {
            config.set(this);
            this.write((Config)config.get(), options);
        }
        return (Config)config.get();
    }

    private void write(Config config, ShopOptionsApi options) {
        config.check();
        ShopApi.configs.put(options.getModId(), config);
        CompletableFuture futureWrite = Utils.writeFileAsync((String)options.getPath(), (String)"config.json", (String)UltraShop.gson.toJson((Object)config));
        if (!((Boolean)futureWrite.join()).booleanValue()) {
            CobbleUtils.LOGGER.error("Error writing file: " + options.getPath() + "config.json");
        }
    }

    private void check() {
        if (this.commands == null || this.commands.isEmpty()) {
            this.commands = new ArrayList<String>();
            this.commands.add("shop");
        }
    }

    public static void readShops(ShopOptionsApi options) {
        ((List)ShopApi.shops.getOrDefault(options.getModId(), new ArrayList())).clear();
        String path = options.getPath() + "shop/";
        File folder = Utils.getAbsolutePath((String)path);
        if (!folder.exists()) {
            folder.mkdirs();
            Config.createDefaultShop(path);
        }
        ArrayList<Shop> shops = new ArrayList<Shop>();
        Config.readAllShops(folder.listFiles(), shops);
        ShopApi.shops.put(options.getModId(), shops);
    }

    private static void createDefaultShop(String path) {
        File folder = Utils.getAbsolutePath((String)path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        ArrayList<Shop> shops = new ArrayList<Shop>();
        shops.add(new Shop(TypeShop.PERMANENT.name(), new ShopTypePermanent()));
        shops.add(new Shop(TypeShop.DYNAMIC.name(), new ShopTypeDynamic()));
        shops.add(new Shop(TypeShop.WEEKLY.name(), new ShopTypeWeekly()));
        shops.add(new Shop(TypeShop.DYNAMIC_WEEKLY.name(), new ShopTypeDynamicWeekly()));
        shops.add(new Shop(TypeShop.CALENDAR.name(), new ShopTypeCalendar()));
        shops.add(new Shop(TypeShop.DYNAMIC_CALENDAR.name(), new ShopTypeDynamicCalendar()));
        shops.add(new Shop("categorys", new ShopTypePermanent()));
        ((Shop)shops.getLast()).setSubShops(List.of(new SubShop(10, TypeShop.PERMANENT.name()), new SubShop(11, TypeShop.DYNAMIC.name()), new SubShop(12, TypeShop.WEEKLY.name()), new SubShop(13, TypeShop.DYNAMIC_WEEKLY.name()), new SubShop(14, TypeShop.CALENDAR.name()), new SubShop(15, TypeShop.DYNAMIC_CALENDAR.name())));
        ((Shop)shops.getLast()).setProducts(new ArrayList<Product>());
        int i = 0;
        for (Shop shop : shops) {
            shop.getDisplay().setSlot(Integer.valueOf(i++));
            shop.check();
            Config.write(path, shop);
        }
    }

    private static void write(String path, Shop shop) {
        String finalPath;
        String string = finalPath = path == null ? shop.getPath() : path;
        if (finalPath == null) {
            return;
        }
        CompletableFuture futureWrite = Utils.writeFileAsync((String)finalPath, (String)(shop.getId() + ".json"), (String)UltraShop.gson.toJson((Object)shop));
        if (!((Boolean)futureWrite.join()).booleanValue()) {
            CobbleUtils.LOGGER.error("Error writing file: " + finalPath + shop.getId() + ".json");
        }
    }

    private static void readAllShops(File[] files, List<Shop> shops) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Config.readAllShops(file.listFiles(), shops);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            Shop shop = null;
            try {
                String path = file.getPath();
                shop = (Shop)UltraShop.gson.fromJson(Utils.readFileSync((File)file), Shop.class);
                shop.setId(file.getName().replace(".json", ""));
                shop.check();
                shop.setPath(null);
                Utils.writeFileSync((File)file, (String)UltraShop.gson.toJson((Object)shop));
                shop.setPath(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            shops.add(shop);
        }
    }

    public void open(class_3222 player, ShopOptionsApi options) {
        ChestTemplate template = ChestTemplate.builder((int)this.rows).build();
        PanelsConfig.applyConfig((ChestTemplate)template, this.panels, (int)this.rows);
        List<Shop> shops = ShopApi.getShops(options);
        Config.applyShops(shops, player, options, this, template, true);
        if (UIUtils.isInside((int)this.itemClose.getSlot(), (int)this.rows)) {
            ItemModel close = UltraShop.lang.getGlobalItemClose(this.itemClose);
            GooeyButton closeButton = close.getButton(1, action -> UIManager.closeUI((class_3222)player));
            template.set(this.itemClose.getSlot().intValue(), (Button)closeButton);
        }
        GooeyPage page = GooeyPage.builder().template((Template)template).title(AdventureTranslator.toNative((String)this.title)).onOpen(action -> new Sound(this.soundOpen).playSoundPlayer(action.getPlayer())).build();
        UIManager.openUIForcefully((class_3222)player, (Page)page);
    }

    public static void applyShops(List<Shop> shops, class_3222 player, ShopOptionsApi options, Config config, ChestTemplate template, boolean withClose) {
        for (Shop shop : shops) {
            if (!UIUtils.isInside((int)shop.getDisplay().getSlot(), (int)config.getRows())) continue;
            ItemModel display = UltraShop.lang.getGlobalDisplay(shop.getDisplay());
            ArrayList lore = new ArrayList(display.getLore());
            lore.replaceAll(s -> shop.getType().replace((String)s, shop, options));
            GooeyButton button = display.getButton(1, display.getDisplayname().replace("%shop%", shop.getId()), lore, action -> Config.manageOpenShop(player, options, config, shop, new Stack<Shop>(), shop, withClose));
            template.set(shop.getDisplay().getSlot().intValue(), (Button)button);
        }
    }

    private static boolean canOpen(class_3222 player, Shop shop) {
        boolean canopen = shop.getType().isOpen();
        if (!canopen) {
            PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageShopNotOpen().replace("%shop%", shop.getId()), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
        }
        return canopen;
    }

    public static void manageOpenShop(class_3222 player, ShopOptionsApi options, Config config, Shop add, Stack<Shop> stack, Shop actual, boolean withClose) {
        Shop shop = null;
        if (stack == null) {
            stack = new Stack();
        }
        if (actual == null) {
            shop = stack.peek();
            shop.open(player, options, config, 0, stack, withClose);
        } else if (add != null) {
            if (Config.canOpen(player, add)) {
                stack.push(add);
                add.open(player, options, config, 0, stack, withClose);
            }
        } else if (stack.isEmpty()) {
            config.open(player, options);
        } else {
            shop = stack.pop();
            if (actual.equals(shop)) {
                if (stack.isEmpty()) {
                    config.open(player, options);
                    return;
                }
                shop = stack.pop();
            }
            shop.open(player, options, config, 0, stack, withClose);
        }
    }

    public void createShop(ShopOptionsApi options, Shop shop) {
        shop.check();
        Config.write(options.getPathShop(), shop);
        UltraShop.load(options);
    }

    @Generated
    public String getPath() {
        return this.Path;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public boolean isSaveTransactions() {
        return this.saveTransactions;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSoundOpen() {
        return this.soundOpen;
    }

    @Generated
    public String getSoundClose() {
        return this.soundClose;
    }

    @Generated
    public DataBaseConfig getDataBase() {
        return this.dataBase;
    }

    @Generated
    public Map<String, Float> getDiscounts() {
        return this.discounts;
    }

    @Generated
    public ItemModel getItemClose() {
        return this.itemClose;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public List<PanelsConfig> getPanels() {
        return this.panels;
    }

    @Generated
    public void setPath(String Path2) {
        this.Path = Path2;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public void setSaveTransactions(boolean saveTransactions) {
        this.saveTransactions = saveTransactions;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setSoundOpen(String soundOpen) {
        this.soundOpen = soundOpen;
    }

    @Generated
    public void setSoundClose(String soundClose) {
        this.soundClose = soundClose;
    }

    @Generated
    public void setDataBase(DataBaseConfig dataBase) {
        this.dataBase = dataBase;
    }

    @Generated
    public void setDiscounts(Map<String, Float> discounts) {
        this.discounts = discounts;
    }

    @Generated
    public void setItemClose(ItemModel itemClose) {
        this.itemClose = itemClose;
    }

    @Generated
    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    @Generated
    public void setPanels(List<PanelsConfig> panels) {
        this.panels = panels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isSaveTransactions() != other.isSaveTransactions()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        String this$Path = this.getPath();
        String other$Path = other.getPath();
        if (this$Path == null ? other$Path != null : !this$Path.equals(other$Path)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$soundOpen = this.getSoundOpen();
        String other$soundOpen = other.getSoundOpen();
        if (this$soundOpen == null ? other$soundOpen != null : !this$soundOpen.equals(other$soundOpen)) {
            return false;
        }
        String this$soundClose = this.getSoundClose();
        String other$soundClose = other.getSoundClose();
        if (this$soundClose == null ? other$soundClose != null : !this$soundClose.equals(other$soundClose)) {
            return false;
        }
        DataBaseConfig this$dataBase = this.getDataBase();
        DataBaseConfig other$dataBase = other.getDataBase();
        if (this$dataBase == null ? other$dataBase != null : !this$dataBase.equals(other$dataBase)) {
            return false;
        }
        Map<String, Float> this$discounts = this.getDiscounts();
        Map<String, Float> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        ItemModel this$itemClose = this.getItemClose();
        ItemModel other$itemClose = other.getItemClose();
        if (this$itemClose == null ? other$itemClose != null : !this$itemClose.equals(other$itemClose)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        List<PanelsConfig> this$panels = this.getPanels();
        List<PanelsConfig> other$panels = other.getPanels();
        return !(this$panels == null ? other$panels != null : !((Object)this$panels).equals(other$panels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isSaveTransactions() ? 79 : 97);
        result = result * 59 + this.getRows();
        String $Path = this.getPath();
        result = result * 59 + ($Path == null ? 43 : $Path.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $soundOpen = this.getSoundOpen();
        result = result * 59 + ($soundOpen == null ? 43 : $soundOpen.hashCode());
        String $soundClose = this.getSoundClose();
        result = result * 59 + ($soundClose == null ? 43 : $soundClose.hashCode());
        DataBaseConfig $dataBase = this.getDataBase();
        result = result * 59 + ($dataBase == null ? 43 : $dataBase.hashCode());
        Map<String, Float> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        ItemModel $itemClose = this.getItemClose();
        result = result * 59 + ($itemClose == null ? 43 : $itemClose.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        List<PanelsConfig> $panels = this.getPanels();
        result = result * 59 + ($panels == null ? 43 : ((Object)$panels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Config(Path=" + this.getPath() + ", debug=" + this.isDebug() + ", saveTransactions=" + this.isSaveTransactions() + ", lang=" + this.getLang() + ", rows=" + this.getRows() + ", title=" + this.getTitle() + ", soundOpen=" + this.getSoundOpen() + ", soundClose=" + this.getSoundClose() + ", dataBase=" + String.valueOf(this.getDataBase()) + ", discounts=" + String.valueOf(this.getDiscounts()) + ", itemClose=" + String.valueOf(this.getItemClose()) + ", commands=" + String.valueOf(this.getCommands()) + ", panels=" + String.valueOf(this.getPanels()) + ")";
    }
}

