/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.database;

import com.kingpixel.ultrashop.models.ActionShop;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.ProductLimit;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.UserInfo;
import java.math.BigDecimal;
import net.minecraft.class_3222;

public abstract class DataBaseClient {
    public abstract void connect();

    public abstract void disconnect();

    public abstract UserInfo getUserInfo(class_3222 var1);

    public abstract void updateUserInfo(UserInfo var1);

    public abstract void addTransaction(class_3222 var1, Shop var2, Product var3, ActionShop var4, int var5, BigDecimal var6);

    public void addProductLimit(class_3222 player, Shop shop, Product product, int amount) {
        UserInfo userInfo = this.getUserInfo(player);
        userInfo.addProductLimit(product, amount);
        userInfo.write(player);
    }

    public boolean canBuy(class_3222 player, Product product) {
        boolean isLimit;
        if (product.getUuid() == null) {
            return true;
        }
        UserInfo userInfo = this.getUserInfo(player);
        ProductLimit productLimit = userInfo.getCooldownProduct().get(product.getUuid());
        boolean isCooldown = productLimit != null && productLimit.getCooldown() > System.currentTimeMillis();
        boolean bl = isLimit = userInfo.getActualProductLimit(product) >= product.getMax();
        if (isLimit) {
            if (isCooldown) {
                return false;
            }
            userInfo.getCooldownProduct().remove(product.getUuid());
            this.updateUserInfo(userInfo);
        }
        return !isLimit;
    }

    public long getProductCooldown(class_3222 player, Product product) {
        UserInfo userInfo = this.getUserInfo(player);
        ProductLimit limit = userInfo.getCooldownProduct().get(product.getUuid());
        return limit == null ? System.currentTimeMillis() : limit.getCooldown();
    }

    public void removeIfNecessary(class_3222 player) {
    }
}

