/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.database;

import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.ultrashop.database.DataBaseClient;
import com.kingpixel.ultrashop.database.DataBaseJSON;
import com.kingpixel.ultrashop.database.DataBaseMySQL;
import com.kingpixel.ultrashop.database.DataBaseSQLite;
import com.kingpixel.ultrashop.models.UserInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DataBaseFactory {
    public static DataBaseClient INSTANCE;
    public static final Map<UUID, UserInfo> users;

    public DataBaseFactory(DataBaseConfig config) {
        if (INSTANCE != null) {
            INSTANCE.disconnect();
        }
        switch (config.getType()) {
            case JSON: {
                INSTANCE = new DataBaseJSON(config);
                break;
            }
            case MYSQL: {
                INSTANCE = new DataBaseMySQL(config);
                break;
            }
            case SQLITE: {
                INSTANCE = new DataBaseSQLite(config);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(config.getType()));
            }
        }
        INSTANCE.connect();
    }

    static {
        users = new HashMap<UUID, UserInfo>();
    }
}

