/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.gui;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.EconomyUse;
import com.kingpixel.cobbleutils.Model.ItemModel;
import com.kingpixel.cobbleutils.Model.PanelsConfig;
import com.kingpixel.cobbleutils.api.EconomyApi;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.cobbleutils.util.UIUtils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.database.DataBaseFactory;
import com.kingpixel.ultrashop.models.ActionShop;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.UserInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3222;

public class MenuBuyAndSell {
    private final int rows;
    private final String titleBuy;
    private final String titleSell;
    private final int productSlot;
    private final ItemModel itemConfirm = new ItemModel(Integer.valueOf(39), "minecraft:lime_stained_glass_pane", "&aConfirm", List.of(), 0);
    private final ItemModel itemClose = new ItemModel(Integer.valueOf(49), "minecraft:barrier", "&cClose", List.of(), 0);
    private final ItemModel itemCancel = new ItemModel(Integer.valueOf(41), "minecraft:red_stained_glass_pane", "&cCancel", List.of(), 0);
    private final List<PanelsConfig> panels = List.of(new PanelsConfig(new ItemModel("minecraft:gray_stained_glass_pane"), this.rows));

    public MenuBuyAndSell() {
        this.rows = 6;
        this.titleBuy = "&aBuy %amount%";
        this.titleSell = "&cSell %amount%";
        this.productSlot = 22;
    }

    public void open(class_3222 player, Stack<Shop> stack, Product product, int amount, ActionShop actionShop, ShopOptionsApi options, Config config, boolean withClose) {
        CompletableFuture.runAsync(() -> {
            int totalStack;
            BigDecimal buyPrice = product.getBuyPrice(player, amount, (Shop)stack.peek(), config);
            if (buyPrice.compareTo(BigDecimal.ZERO) > 0 && buyPrice.compareTo(product.getSellPrice(amount)) < 0) {
                PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageBuyPriceLessThanSell(), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                return;
            }
            if (!product.isBuyable() && actionShop.equals((Object)ActionShop.BUY)) {
                return;
            }
            if (!(product.isSellable() && product.canSell(player, (Shop)stack.peek(), options) || !actionShop.equals((Object)ActionShop.SELL))) {
                PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotSell(), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                return;
            }
            ChestTemplate template = ChestTemplate.builder((int)this.rows).build();
            PanelsConfig.applyConfig((ChestTemplate)template, this.panels);
            if (UIUtils.isInside((int)this.productSlot, (int)this.rows)) {
                EconomyUse economyUse = ((Shop)stack.peek()).getEconomy();
                BigDecimal balance = EconomyApi.getBalance((UUID)player.method_5667(), (EconomyUse)economyUse);
                String playerBalance = EconomyApi.formatMoney((BigDecimal)balance, (EconomyUse)economyUse);
                template.set(this.productSlot, (Button)product.getIcon(player, stack, actionShop, amount, options, config, withClose, playerBalance));
            }
            if ((totalStack = product.getStack()) != 1) {
                this.putButton(player, stack, product, amount, actionShop, options, config, withClose, template, UltraShop.lang.getAdd1(), 1, UltraShop.lang.getRemove1());
                this.putButton(player, stack, product, amount, actionShop, options, config, withClose, template, UltraShop.lang.getAdd8(), 8, UltraShop.lang.getRemove8());
                this.putButton(player, stack, product, amount, actionShop, options, config, withClose, template, UltraShop.lang.getAdd16(), 16, UltraShop.lang.getRemove16());
                this.putButton(player, stack, product, amount, actionShop, options, config, withClose, template, UltraShop.lang.getAdd64(), 64, UltraShop.lang.getRemove64());
            }
            this.itemCancel.applyTemplate(template, this.itemCancel.getButton(action -> Config.manageOpenShop(player, options, config, null, stack, null, withClose)));
            this.itemClose.applyTemplate(template, this.itemClose.getButton(action -> Config.manageOpenShop(player, options, config, null, stack, null, withClose)));
            this.itemConfirm.applyTemplate(template, this.itemConfirm.getButton(action -> {
                Shop shop = (Shop)stack.peek();
                if (actionShop.equals((Object)ActionShop.BUY)) {
                    int finalAmount = amount;
                    if (product.getUuid() != null) {
                        int max;
                        UserInfo userinfo = DataBaseFactory.INSTANCE.getUserInfo(player);
                        int actual = userinfo.getActualProductLimit(product);
                        if (actual >= (max = product.getMax().intValue())) {
                            UIManager.closeUI((class_3222)player);
                        }
                        finalAmount = Math.min(finalAmount, max);
                        if (ShopApi.getMainConfig().isDebug()) {
                            CobbleUtils.LOGGER.info("ultrashop", "Limit: " + actual + " / " + max + " - Uuid: " + String.valueOf(product.getUuid()) + " - Amount: " + finalAmount);
                        }
                    }
                    shop.getType().buyProduct(player, product, shop, finalAmount, options, config, stack, withClose);
                } else {
                    product.sell(player, shop, amount, product, options, config, stack, withClose);
                }
            }));
            GooeyPage page = GooeyPage.builder().template((Template)template).title(AdventureTranslator.toNative((String)(actionShop.equals((Object)ActionShop.BUY) ? this.titleBuy : this.titleSell).replace("%amount%", "" + amount))).build();
            UIManager.openUIForcefully((class_3222)player, (Page)page);
        }, UltraShop.SHOP_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    private void putButton(class_3222 player, Stack<Shop> stack, Product product, int amount, ActionShop actionShop, ShopOptionsApi options, Config config, boolean withClose, ChestTemplate template, ItemModel buttonAdd, int i, ItemModel buttonRemove) {
        buttonAdd.applyTemplate(template, buttonAdd.getButton(action -> this.open(player, stack, product, amount + i, actionShop, options, config, withClose)));
        buttonRemove.applyTemplate(template, buttonRemove.getButton(action -> this.open(player, stack, product, Math.max(amount - i, 1), actionShop, options, config, withClose)));
    }
}

