/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.migrate;

import ca.landonjw.gooeylibs2.api.template.TemplateType;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.ItemChance;
import com.kingpixel.cobbleutils.Model.ItemModel;
import com.kingpixel.cobbleutils.Model.PanelsConfig;
import com.kingpixel.cobbleutils.Model.Rectangle;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.migrate.FillItems;
import com.kingpixel.ultrashop.migrate.OldProduct;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.SubShop;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class OldShop {
    private boolean active = true;
    private String id;
    private String title;
    private short rows;
    private String currency;
    private TemplateType templateType;
    private ShopType shopType;
    private Rectangle rectangle;
    private ItemModel display;
    private ItemModel itemInfoShop;
    private short slotbalance;
    private int globalDiscount;
    private String soundopen;
    private String soundclose;
    private String colorItem;
    private ItemModel previous;
    private String closeCommand;
    private ItemModel close;
    private ItemModel next;
    private List<OldProduct> products;
    private List<Integer> slotsPrevious;
    private List<Integer> slotsClose;
    private List<Integer> slotsNext;
    private ItemModel fill;
    private List<FillItems> fillItems;

    public OldShop() {
        this.id = "";
        this.title = "";
        this.rows = (short)3;
        this.currency = "dollars";
        this.templateType = TemplateType.CHEST;
        this.rectangle = new Rectangle();
        this.itemInfoShop = this.display = new ItemModel("cobblemon:poke_ball");
        this.slotbalance = (short)47;
        this.globalDiscount = 0;
        this.soundopen = "cobblemon:pc.on";
        this.soundclose = "cobblemon:pc.off";
        this.colorItem = "<#6bd68f>";
        this.closeCommand = "";
        this.close = CobbleUtils.language.getItemClose();
        this.close.setSlot(Integer.valueOf(49));
        this.next = CobbleUtils.language.getItemNext();
        this.next.setSlot(Integer.valueOf(53));
        this.previous = CobbleUtils.language.getItemPrevious();
        this.previous.setSlot(Integer.valueOf(45));
        this.products = OldShop.getDefaultProducts();
        this.fill = new ItemModel("");
        this.fillItems = new ArrayList<FillItems>();
        this.fillItems.add(new FillItems());
        this.shopType = new ShopTypePermanent();
    }

    public OldShop(String id, String title, ShopType shopType, short rows, List<String> lore) {
        this.id = id;
        this.title = title;
        this.rows = rows;
        this.slotbalance = (short)47;
        this.slotsNext = new ArrayList<Integer>();
        this.slotsPrevious = new ArrayList<Integer>();
        this.slotsClose = new ArrayList<Integer>();
        this.soundopen = "cobblemon:pc.on";
        this.soundclose = "cobblemon:pc.off";
        this.currency = "dollars";
        this.templateType = TemplateType.CHEST;
        this.rectangle = new Rectangle();
        this.shopType = shopType;
        this.colorItem = "<#6bd68f>";
        this.closeCommand = "";
        this.close = CobbleUtils.language.getItemClose();
        this.close.setSlot(Integer.valueOf(49));
        this.next = CobbleUtils.language.getItemNext();
        this.next.setSlot(Integer.valueOf(53));
        this.previous = CobbleUtils.language.getItemPrevious();
        this.previous.setSlot(Integer.valueOf(45));
        this.globalDiscount = 0;
        this.display = new ItemModel("cobblemon:poke_ball");
        this.display.setDisplayname(title);
        this.display.setLore(lore);
        this.itemInfoShop = this.display;
        this.products = OldShop.getDefaultProducts();
        this.fill = new ItemModel("");
        this.fillItems = new ArrayList<FillItems>();
        this.fillItems.add(new FillItems());
    }

    public static List<OldProduct> getDefaultProducts() {
        ArrayList<OldProduct> products = new ArrayList<OldProduct>();
        ItemChance.defaultItemChances().forEach(itemChance -> {
            OldProduct product = new OldProduct();
            product.setProduct(itemChance.getItem());
            product.setBuy(BigDecimal.valueOf(100L));
            product.setSell(BigDecimal.valueOf(25L));
            products.add(product);
        });
        products.add(new OldProduct(true));
        return products;
    }

    public static void migration() {
        File[] files;
        File folder = Utils.getAbsolutePath((String)"/config/ultrashop/migration/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".json")) continue;
                boolean read = Utils.readFileSync((File)file, call -> {
                    OldShop shop = (OldShop)UltraShop.gson.fromJson(call, OldShop.class);
                    CompletableFuture futureWrite = Utils.writeFileAsync((String)"/config/ultrashop/shop/", (String)file.getName(), (String)UltraShop.gson.toJson((Object)OldShop.from(shop)));
                    CompletableFuture futureBackup = Utils.writeFileAsync((String)"/config/ultrashop/backup_migration/", (String)file.getName(), (String)call);
                    if (!((Boolean)futureBackup.join()).booleanValue()) {
                        CobbleUtils.LOGGER.error("Error writing file: /config/ultrashop/backup_migration/" + file.getName());
                    }
                    if (!((Boolean)futureWrite.join()).booleanValue()) {
                        CobbleUtils.LOGGER.error("Error writing file: /config/ultrashop/migration/" + file.getName());
                    }
                });
                if (!read) {
                    CobbleUtils.LOGGER.error("Error reading file: /config/ultrashop/migration/" + file.getName());
                    continue;
                }
                file.delete();
            }
        }
    }

    public static Shop from(OldShop oldShop) {
        Shop shop = new Shop();
        shop.setAutoPlace(true);
        shop.setId(oldShop.getId());
        shop.setTitle(oldShop.getTitle());
        shop.setCloseCommand(oldShop.getCloseCommand());
        shop.setSoundOpen(oldShop.getSoundopen());
        shop.setSoundClose(oldShop.getSoundclose());
        shop.setRows(oldShop.getRows());
        shop.setType(oldShop.getShopType() == null ? new ShopTypePermanent() : oldShop.getShopType());
        shop.setSubShops(new ArrayList<SubShop>());
        shop.setRectangle(oldShop.getRectangle());
        shop.setDisplay(oldShop.getDisplay());
        shop.setItemInfoShop(oldShop.getItemInfoShop());
        shop.setGlobalDiscount(oldShop.getGlobalDiscount());
        shop.getItemBalance().setSlot(Integer.valueOf(oldShop.getSlotbalance()));
        shop.setProducts(OldShop.getProducts(oldShop.products));
        shop.setItemPrevious(oldShop.getPrevious());
        shop.setItemClose(oldShop.getClose());
        shop.setItemNext(oldShop.getNext());
        shop.setPanels(List.of(new PanelsConfig(oldShop.fill, (int)oldShop.getRows())));
        return shop;
    }

    private static List<Product> getProducts(List<OldProduct> products) {
        ArrayList<Product> newProducts = new ArrayList<Product>();
        for (OldProduct oldProduct : products) {
            newProducts.add(oldProduct.from());
        }
        return newProducts;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public short getRows() {
        return this.rows;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public TemplateType getTemplateType() {
        return this.templateType;
    }

    @Generated
    public ShopType getShopType() {
        return this.shopType;
    }

    @Generated
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Generated
    public ItemModel getDisplay() {
        return this.display;
    }

    @Generated
    public ItemModel getItemInfoShop() {
        return this.itemInfoShop;
    }

    @Generated
    public short getSlotbalance() {
        return this.slotbalance;
    }

    @Generated
    public int getGlobalDiscount() {
        return this.globalDiscount;
    }

    @Generated
    public String getSoundopen() {
        return this.soundopen;
    }

    @Generated
    public String getSoundclose() {
        return this.soundclose;
    }

    @Generated
    public String getColorItem() {
        return this.colorItem;
    }

    @Generated
    public ItemModel getPrevious() {
        return this.previous;
    }

    @Generated
    public String getCloseCommand() {
        return this.closeCommand;
    }

    @Generated
    public ItemModel getClose() {
        return this.close;
    }

    @Generated
    public ItemModel getNext() {
        return this.next;
    }

    @Generated
    public List<OldProduct> getProducts() {
        return this.products;
    }

    @Generated
    public List<Integer> getSlotsPrevious() {
        return this.slotsPrevious;
    }

    @Generated
    public List<Integer> getSlotsClose() {
        return this.slotsClose;
    }

    @Generated
    public List<Integer> getSlotsNext() {
        return this.slotsNext;
    }

    @Generated
    public ItemModel getFill() {
        return this.fill;
    }

    @Generated
    public List<FillItems> getFillItems() {
        return this.fillItems;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setRows(short rows) {
        this.rows = rows;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    @Generated
    public void setShopType(ShopType shopType) {
        this.shopType = shopType;
    }

    @Generated
    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Generated
    public void setDisplay(ItemModel display) {
        this.display = display;
    }

    @Generated
    public void setItemInfoShop(ItemModel itemInfoShop) {
        this.itemInfoShop = itemInfoShop;
    }

    @Generated
    public void setSlotbalance(short slotbalance) {
        this.slotbalance = slotbalance;
    }

    @Generated
    public void setGlobalDiscount(int globalDiscount) {
        this.globalDiscount = globalDiscount;
    }

    @Generated
    public void setSoundopen(String soundopen) {
        this.soundopen = soundopen;
    }

    @Generated
    public void setSoundclose(String soundclose) {
        this.soundclose = soundclose;
    }

    @Generated
    public void setColorItem(String colorItem) {
        this.colorItem = colorItem;
    }

    @Generated
    public void setPrevious(ItemModel previous) {
        this.previous = previous;
    }

    @Generated
    public void setCloseCommand(String closeCommand) {
        this.closeCommand = closeCommand;
    }

    @Generated
    public void setClose(ItemModel close) {
        this.close = close;
    }

    @Generated
    public void setNext(ItemModel next) {
        this.next = next;
    }

    @Generated
    public void setProducts(List<OldProduct> products) {
        this.products = products;
    }

    @Generated
    public void setSlotsPrevious(List<Integer> slotsPrevious) {
        this.slotsPrevious = slotsPrevious;
    }

    @Generated
    public void setSlotsClose(List<Integer> slotsClose) {
        this.slotsClose = slotsClose;
    }

    @Generated
    public void setSlotsNext(List<Integer> slotsNext) {
        this.slotsNext = slotsNext;
    }

    @Generated
    public void setFill(ItemModel fill) {
        this.fill = fill;
    }

    @Generated
    public void setFillItems(List<FillItems> fillItems) {
        this.fillItems = fillItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OldShop)) {
            return false;
        }
        OldShop other = (OldShop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getSlotbalance() != other.getSlotbalance()) {
            return false;
        }
        if (this.getGlobalDiscount() != other.getGlobalDiscount()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        TemplateType this$templateType = this.getTemplateType();
        TemplateType other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !this$templateType.equals(other$templateType)) {
            return false;
        }
        ShopType this$shopType = this.getShopType();
        ShopType other$shopType = other.getShopType();
        if (this$shopType == null ? other$shopType != null : !this$shopType.equals(other$shopType)) {
            return false;
        }
        Rectangle this$rectangle = this.getRectangle();
        Rectangle other$rectangle = other.getRectangle();
        if (this$rectangle == null ? other$rectangle != null : !this$rectangle.equals(other$rectangle)) {
            return false;
        }
        ItemModel this$display = this.getDisplay();
        ItemModel other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        ItemModel this$itemInfoShop = this.getItemInfoShop();
        ItemModel other$itemInfoShop = other.getItemInfoShop();
        if (this$itemInfoShop == null ? other$itemInfoShop != null : !this$itemInfoShop.equals(other$itemInfoShop)) {
            return false;
        }
        String this$soundopen = this.getSoundopen();
        String other$soundopen = other.getSoundopen();
        if (this$soundopen == null ? other$soundopen != null : !this$soundopen.equals(other$soundopen)) {
            return false;
        }
        String this$soundclose = this.getSoundclose();
        String other$soundclose = other.getSoundclose();
        if (this$soundclose == null ? other$soundclose != null : !this$soundclose.equals(other$soundclose)) {
            return false;
        }
        String this$colorItem = this.getColorItem();
        String other$colorItem = other.getColorItem();
        if (this$colorItem == null ? other$colorItem != null : !this$colorItem.equals(other$colorItem)) {
            return false;
        }
        ItemModel this$previous = this.getPrevious();
        ItemModel other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !this$previous.equals(other$previous)) {
            return false;
        }
        String this$closeCommand = this.getCloseCommand();
        String other$closeCommand = other.getCloseCommand();
        if (this$closeCommand == null ? other$closeCommand != null : !this$closeCommand.equals(other$closeCommand)) {
            return false;
        }
        ItemModel this$close = this.getClose();
        ItemModel other$close = other.getClose();
        if (this$close == null ? other$close != null : !this$close.equals(other$close)) {
            return false;
        }
        ItemModel this$next = this.getNext();
        ItemModel other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        List<OldProduct> this$products = this.getProducts();
        List<OldProduct> other$products = other.getProducts();
        if (this$products == null ? other$products != null : !((Object)this$products).equals(other$products)) {
            return false;
        }
        List<Integer> this$slotsPrevious = this.getSlotsPrevious();
        List<Integer> other$slotsPrevious = other.getSlotsPrevious();
        if (this$slotsPrevious == null ? other$slotsPrevious != null : !((Object)this$slotsPrevious).equals(other$slotsPrevious)) {
            return false;
        }
        List<Integer> this$slotsClose = this.getSlotsClose();
        List<Integer> other$slotsClose = other.getSlotsClose();
        if (this$slotsClose == null ? other$slotsClose != null : !((Object)this$slotsClose).equals(other$slotsClose)) {
            return false;
        }
        List<Integer> this$slotsNext = this.getSlotsNext();
        List<Integer> other$slotsNext = other.getSlotsNext();
        if (this$slotsNext == null ? other$slotsNext != null : !((Object)this$slotsNext).equals(other$slotsNext)) {
            return false;
        }
        ItemModel this$fill = this.getFill();
        ItemModel other$fill = other.getFill();
        if (this$fill == null ? other$fill != null : !this$fill.equals(other$fill)) {
            return false;
        }
        List<FillItems> this$fillItems = this.getFillItems();
        List<FillItems> other$fillItems = other.getFillItems();
        return !(this$fillItems == null ? other$fillItems != null : !((Object)this$fillItems).equals(other$fillItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OldShop;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getRows();
        result = result * 59 + this.getSlotbalance();
        result = result * 59 + this.getGlobalDiscount();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        TemplateType $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : $templateType.hashCode());
        ShopType $shopType = this.getShopType();
        result = result * 59 + ($shopType == null ? 43 : $shopType.hashCode());
        Rectangle $rectangle = this.getRectangle();
        result = result * 59 + ($rectangle == null ? 43 : $rectangle.hashCode());
        ItemModel $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        ItemModel $itemInfoShop = this.getItemInfoShop();
        result = result * 59 + ($itemInfoShop == null ? 43 : $itemInfoShop.hashCode());
        String $soundopen = this.getSoundopen();
        result = result * 59 + ($soundopen == null ? 43 : $soundopen.hashCode());
        String $soundclose = this.getSoundclose();
        result = result * 59 + ($soundclose == null ? 43 : $soundclose.hashCode());
        String $colorItem = this.getColorItem();
        result = result * 59 + ($colorItem == null ? 43 : $colorItem.hashCode());
        ItemModel $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
        String $closeCommand = this.getCloseCommand();
        result = result * 59 + ($closeCommand == null ? 43 : $closeCommand.hashCode());
        ItemModel $close = this.getClose();
        result = result * 59 + ($close == null ? 43 : $close.hashCode());
        ItemModel $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        List<OldProduct> $products = this.getProducts();
        result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
        List<Integer> $slotsPrevious = this.getSlotsPrevious();
        result = result * 59 + ($slotsPrevious == null ? 43 : ((Object)$slotsPrevious).hashCode());
        List<Integer> $slotsClose = this.getSlotsClose();
        result = result * 59 + ($slotsClose == null ? 43 : ((Object)$slotsClose).hashCode());
        List<Integer> $slotsNext = this.getSlotsNext();
        result = result * 59 + ($slotsNext == null ? 43 : ((Object)$slotsNext).hashCode());
        ItemModel $fill = this.getFill();
        result = result * 59 + ($fill == null ? 43 : $fill.hashCode());
        List<FillItems> $fillItems = this.getFillItems();
        result = result * 59 + ($fillItems == null ? 43 : ((Object)$fillItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OldShop(active=" + this.isActive() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", rows=" + this.getRows() + ", currency=" + this.getCurrency() + ", templateType=" + String.valueOf(this.getTemplateType()) + ", shopType=" + String.valueOf(this.getShopType()) + ", rectangle=" + String.valueOf(this.getRectangle()) + ", display=" + String.valueOf(this.getDisplay()) + ", itemInfoShop=" + String.valueOf(this.getItemInfoShop()) + ", slotbalance=" + this.getSlotbalance() + ", globalDiscount=" + this.getGlobalDiscount() + ", soundopen=" + this.getSoundopen() + ", soundclose=" + this.getSoundclose() + ", colorItem=" + this.getColorItem() + ", previous=" + String.valueOf(this.getPrevious()) + ", closeCommand=" + this.getCloseCommand() + ", close=" + String.valueOf(this.getClose()) + ", next=" + String.valueOf(this.getNext()) + ", products=" + String.valueOf(this.getProducts()) + ", slotsPrevious=" + String.valueOf(this.getSlotsPrevious()) + ", slotsClose=" + String.valueOf(this.getSlotsClose()) + ", slotsNext=" + String.valueOf(this.getSlotsNext()) + ", fill=" + String.valueOf(this.getFill()) + ", fillItems=" + String.valueOf(this.getFillItems()) + ")";
    }
}

