/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.models;

import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicWeekly;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.DynamicProduct;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class DataShop {
    public Map<String, Map<String, DynamicProduct>> products = new HashMap<String, Map<String, DynamicProduct>>();

    public void init() {
        CompletableFuture futureRead;
        File file = Utils.getAbsolutePath((String)"/config/ultrashop/data/");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (Boolean.FALSE.equals((futureRead = Utils.readFileAsync((String)"/config/ultrashop/data/", (String)"dataShop.json", call -> {
            try {
                UltraShop.dataShop = (DataShop)UltraShop.gsonWithOutSpaces.fromJson(call, DataShop.class);
                if (UltraShop.dataShop == null) {
                    UltraShop.dataShop = new DataShop();
                }
                this.check();
                this.write();
            }
            catch (Exception e) {
                e.printStackTrace();
                UltraShop.dataShop = new DataShop();
                this.write();
            }
        })).join())) {
            UltraShop.dataShop = new DataShop();
            this.write();
        }
    }

    public synchronized void write() {
        File file = Utils.getAbsolutePath((String)"/config/ultrashop/data/dataShop.json");
        Utils.writeFileSync((File)file, (String)UltraShop.gsonWithOutSpaces.toJson((Object)UltraShop.dataShop));
    }

    public void check() {
        boolean changed = false;
        if (changed) {
            this.write();
        }
    }

    public List<Product> updateDynamicProducts(Shop shop, ShopOptionsApi options) {
        this.products.computeIfAbsent(options.getModId(), k -> new HashMap()).computeIfAbsent(shop.getId(), k -> new DynamicProduct());
        DynamicProduct dynamicProduct = this.products.get(options.getModId()).get(shop.getId());
        if (dynamicProduct.getTimeToUpdate() < System.currentTimeMillis() || dynamicProduct.getProducts().isEmpty() || dynamicProduct.getProducts().size() != this.getRotationProducts(shop)) {
            CompletableFuture.runAsync(() -> {
                dynamicProduct.setTimeToUpdate(System.currentTimeMillis() + this.getCooldown(shop.getType()));
                List<Product> nuevosProductos = this.getNewProducts(shop, options);
                dynamicProduct.setProducts(nuevosProductos);
                this.write();
                UltraShop.initSellProduct(options);
            }, UltraShop.SHOP_EXECUTOR).orTimeout(5L, TimeUnit.SECONDS).exceptionally(e -> {
                e.printStackTrace();
                return null;
            });
        }
        return dynamicProduct.getProducts();
    }

    private int getRotationProducts(Shop shop) {
        ShopType shopType = shop.getType();
        if (shopType instanceof ShopTypeDynamic) {
            ShopTypeDynamic shopTypeDynamic = (ShopTypeDynamic)shopType;
            return shopTypeDynamic.getProductsRotation();
        }
        if (shopType instanceof ShopTypeDynamicWeekly) {
            ShopTypeDynamicWeekly shopTypeDynamicWeekly = (ShopTypeDynamicWeekly)shopType;
            return shopTypeDynamicWeekly.getProductsRotation();
        }
        return 3;
    }

    public long getCooldown(ShopType shopType) {
        long cooldown = 30L;
        if (shopType instanceof ShopTypeDynamic) {
            ShopTypeDynamic shopTypeDynamic = (ShopTypeDynamic)shopType;
            cooldown = shopTypeDynamic.getCooldown();
        } else if (shopType instanceof ShopTypeDynamicWeekly) {
            ShopTypeDynamicWeekly shopTypeDynamicWeekly = (ShopTypeDynamicWeekly)shopType;
            cooldown = shopTypeDynamicWeekly.getCooldown();
        }
        return TimeUnit.MINUTES.toMillis(cooldown);
    }

    public List<Product> getNewProducts(Shop shop, ShopOptionsApi options) {
        int productsRotation = this.getRotationProducts(shop);
        List<Product> products = new ArrayList<Product>(shop.getProducts());
        Collections.shuffle(products);
        if (products.size() > productsRotation) {
            products = products.subList(0, productsRotation);
        }
        return products;
    }

    public long getActualCooldown(Shop shop, ShopOptionsApi shopOptionsApi) {
        return this.products.computeIfAbsent(shopOptionsApi.getModId(), k -> new HashMap()).computeIfAbsent(shop.getId(), k -> new DynamicProduct()).getTimeToUpdate();
    }

    @Generated
    public Map<String, Map<String, DynamicProduct>> getProducts() {
        return this.products;
    }

    @Generated
    public void setProducts(Map<String, Map<String, DynamicProduct>> products) {
        this.products = products;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataShop)) {
            return false;
        }
        DataShop other = (DataShop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<String, DynamicProduct>> this$products = this.getProducts();
        Map<String, Map<String, DynamicProduct>> other$products = other.getProducts();
        return !(this$products == null ? other$products != null : !((Object)this$products).equals(other$products));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataShop;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<String, DynamicProduct>> $products = this.getProducts();
        result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataShop(products=" + String.valueOf(this.getProducts()) + ")";
    }
}

