/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.models;

import ca.landonjw.gooeylibs2.api.button.ButtonClick;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.EconomyUse;
import com.kingpixel.cobbleutils.Model.ItemChance;
import com.kingpixel.cobbleutils.Model.Sound;
import com.kingpixel.cobbleutils.api.EconomyApi;
import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.database.DataBaseFactory;
import com.kingpixel.ultrashop.models.ActionShop;
import com.kingpixel.ultrashop.models.Shop;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class Product {
    private Boolean oneByOne;
    private UUID uuid;
    private Integer max;
    private Integer cooldown;
    private String canBuyPermission;
    private String notBuyPermission;
    private Float discount;
    private String display;
    private String displayname;
    private List<String> lore;
    private Integer CustomModelData;
    private Integer slot;
    private String product;
    private BigDecimal buy;
    private BigDecimal sell;

    public Product() {
        this.product = "minecraft:stone";
        this.buy = BigDecimal.valueOf(9999999L);
        this.sell = BigDecimal.valueOf(0L);
    }

    public Product(boolean optional) {
        if (optional) {
            this.oneByOne = true;
            this.uuid = UUID.randomUUID();
            this.max = 1;
            this.cooldown = 60;
            this.canBuyPermission = "ultrashop.dirt";
            this.notBuyPermission = "ultrashop.dirt";
            this.discount = Float.valueOf(10.0f);
            this.display = "minecraft:stone";
            this.displayname = "Custom Stone";
            this.lore = List.of("This is a custom stone", "You can use it to build");
            this.CustomModelData = 0;
            this.slot = 0;
        }
    }

    public void check(Shop shop) {
        if (this.product == null) {
            this.product = "minecraft:stone";
        }
        if (!shop.isAutoPlace() && this.slot == null) {
            this.slot = 0;
        }
        if (this.cooldown != null || this.max != null) {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            if (this.max == null) {
                this.max = 1;
            }
            if (this.cooldown == null) {
                this.cooldown = 60;
            }
        }
    }

    public GooeyButton getIcon(class_3222 player, Stack<Shop> shop, ActionShop actionShop, int amount, ShopOptionsApi options, Config config, boolean withClose, String playerBalance) {
        Shop peek = shop.peek();
        String finalDisplay = this.display != null ? this.display : this.product;
        ItemChance itemChance = new ItemChance(finalDisplay, 0);
        String title = this.displayname != null ? this.displayname : itemChance.getTitle();
        ArrayList<String> lore = new ArrayList<String>(UltraShop.lang.getInfoProduct());
        lore.removeIf(s -> {
            boolean discount;
            boolean notBuyable;
            boolean notSellable;
            if (s == null || s.isEmpty()) {
                return false;
            }
            boolean bl = notSellable = this.sell == null || this.sell.compareTo(BigDecimal.ZERO) <= 0;
            if (notSellable && (s.contains("%sell%") || s.contains("%removesell%"))) {
                return true;
            }
            boolean bl2 = notBuyable = this.buy == null || this.buy.compareTo(BigDecimal.ZERO) <= 0;
            if (notBuyable && (s.contains("%buy%") || s.contains("%removebuy%"))) {
                return true;
            }
            boolean bl3 = discount = this.getDiscount(player, peek, config) > 0.0f;
            if (!discount && s.contains("%removediscount%")) {
                return true;
            }
            if (actionShop != null) {
                if (actionShop.equals((Object)ActionShop.BUY) && (s.contains("%sell%") || s.contains("%removesell%"))) {
                    return true;
                }
                return actionShop.equals((Object)ActionShop.SELL) && (s.contains("%buy%") || s.contains("%removebuy%"));
            }
            return false;
        });
        lore.replaceAll(s -> this.replace(player, (String)s, (Shop)shop.peek(), amount, config, playerBalance));
        boolean infoReplaced = false;
        if (this.lore != null) {
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                if (!line.contains("%info%")) continue;
                lore.remove(i);
                lore.addAll(i, this.lore);
                infoReplaced = true;
                break;
            }
        }
        if (!infoReplaced) {
            lore.replaceAll(s -> s.contains("%info%") ? UltraShop.lang.getNotExtraInfo() : s);
        } else {
            lore.removeIf(s -> s.contains("%info%"));
        }
        class_1799 itemStack = itemChance.getItemStack();
        if (amount == itemStack.method_7947()) {
            itemStack.method_7939(amount);
        }
        if (itemStack.method_7947() == 0) {
            itemStack.method_7939(1);
        }
        if (this.CustomModelData != null && itemStack.method_57824(class_9334.field_49637) == null) {
            itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(this.CustomModelData.intValue()));
        }
        GooeyButton.Builder builder = GooeyButton.builder().display(itemStack).with(class_9334.field_49631, (Object)AdventureTranslator.toNative((String)(peek.getColorProduct() + title))).with(class_9334.field_49632, (Object)new class_9290(AdventureTranslator.toNativeL(lore))).with(class_9334.field_49638, (Object)class_3902.field_17274);
        return builder.onClick(action -> {
            try {
                ActionShop shopAction = switch (action.getClickType()) {
                    case ButtonClick.LEFT_CLICK, ButtonClick.SHIFT_LEFT_CLICK -> ActionShop.BUY;
                    case ButtonClick.RIGHT_CLICK, ButtonClick.SHIFT_RIGHT_CLICK -> ActionShop.SELL;
                    default -> ActionShop.BUY;
                };
                if (this.havePermission(player, peek)) {
                    new Sound(peek.getSoundOpen()).playSoundPlayer(player);
                    if (DataBaseFactory.INSTANCE.canBuy(player, this)) {
                        UltraShop.lang.getMenuBuyAndSell().open(player, shop, this, amount, shopAction, options, config, withClose);
                    } else {
                        PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageYouCantBuyNow().replace("%limit%", String.valueOf(this.max)).replace("%time%", PlayerUtils.getCooldown((long)DataBaseFactory.INSTANCE.getProductCooldown(player, this))), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                    }
                } else {
                    PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotBuyPermission(), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).build();
    }

    public boolean havePermission(class_3222 player, Shop shop) {
        if (this.notBuyPermission != null && PermissionApi.hasPermission((class_3222)player, (String)this.notBuyPermission, (int)4)) {
            return false;
        }
        return this.canBuyPermission == null || PermissionApi.hasPermission((class_3222)player, (String)this.canBuyPermission, (int)4);
    }

    private float getEspecialDiscount(Map<String, Float> discounts, class_3222 player, float result) {
        if (discounts != null && !discounts.isEmpty()) {
            for (Map.Entry<String, Float> entry : discounts.entrySet()) {
                Float value = entry.getValue();
                if (result >= value.floatValue() || !PermissionApi.hasPermission((class_3222)player, (String)entry.getKey(), (int)4)) continue;
                result = entry.getValue().floatValue();
            }
        }
        return result;
    }

    private float getDiscount(class_3222 player, Shop shop, Config config) {
        float result = 0.0f;
        result = this.getEspecialDiscount(shop.getDiscounts(), player, result);
        result = this.getEspecialDiscount(config.getDiscounts(), player, result);
        if (shop.getGlobalDiscount() <= 0.0f) {
            float a;
            float f = a = this.discount != null ? this.discount.floatValue() : 0.0f;
            if (a > result) {
                result = a;
            }
        } else if (shop.getGlobalDiscount() > result) {
            result = shop.getGlobalDiscount();
        }
        return result;
    }

    public BigDecimal getBuyPrice(class_3222 player, int amount, Shop shop, Config config) {
        BigDecimal totalBuy = this.buy.multiply(BigDecimal.valueOf(amount));
        totalBuy = totalBuy.subtract(totalBuy.multiply(BigDecimal.valueOf((double)this.getDiscount(player, shop, config) / 100.0)));
        return totalBuy.setScale(5, RoundingMode.UNNECESSARY);
    }

    public BigDecimal getSellPrice(int amount) {
        BigDecimal copySell = this.sell.setScale(5, RoundingMode.UNNECESSARY);
        return copySell.multiply(BigDecimal.valueOf(amount));
    }

    public BigDecimal getSellPricePerUnit(class_1799 itemStack) {
        int amount;
        if (itemStack == null) {
            itemStack = this.getItemStack();
        }
        if ((amount = itemStack.method_7947()) == 1) {
            return this.sell;
        }
        return this.sell.divide(BigDecimal.valueOf(amount), 5, RoundingMode.UNNECESSARY);
    }

    private String replace(class_3222 player, String s, Shop shop, int amount, Config config, String playerBalance) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        EconomyUse economy = shop.getEconomy();
        if (s.contains("%buy%")) {
            BigDecimal buyPrice = this.getBuyPrice(player, amount, shop, config);
            s = s.replace("%buy%", EconomyApi.formatMoney((BigDecimal)buyPrice, (EconomyUse)economy));
        }
        if (s.contains("%sell%")) {
            BigDecimal sellPrice = this.getSellPrice(amount);
            s = s.replace("%sell%", EconomyApi.formatMoney((BigDecimal)sellPrice, (EconomyUse)economy));
        }
        if (s.contains("%amount%")) {
            s = s.replace("%amount%", String.valueOf(amount));
        }
        if (s.contains("%pack%")) {
            s = s.replace("%pack%", String.valueOf(this.getItemStack().method_7947()));
        }
        if (s.contains("%discount%")) {
            float discount = this.getDiscount(player, shop, config);
            s = s.replace("%discount%", (CharSequence)(discount > 0.0f ? discount + "%" : ""));
        }
        if (s.contains("%removebuy%")) {
            s = s.replace("%removebuy%", "");
        }
        if (s.contains("%removesell%")) {
            s = s.replace("%removesell%", "");
        }
        if (s.contains("%removediscount%")) {
            s = s.replace("%removediscount%", "");
        }
        s = s.replace("%balance%", playerBalance == null ? "" : playerBalance);
        return s;
    }

    public boolean isSellable() {
        return this.sell != null && this.sell.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isBuyable() {
        return this.buy != null && this.buy.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean buy(class_3222 player, Shop shop, int amount, ShopOptionsApi options, Config config, Stack<Shop> stack, boolean withClose) {
        int maxStack;
        int slotsNeeded;
        boolean result = false;
        ItemChance itemChance = new ItemChance(this.product, 0);
        class_1799 itemStack = itemChance.getItemStack();
        itemStack.method_7939(amount);
        int emptySlots = 0;
        class_2371 inventoryMain = player.method_31548().field_7547;
        for (class_1799 item : inventoryMain) {
            if (!item.method_7960()) continue;
            ++emptySlots;
        }
        if (!(this.product.startsWith("command:") || this.product.startsWith("pokemon:") || this.product.contains("|") || emptySlots >= (slotsNeeded = (int)Math.ceil((double)amount / (double)(maxStack = itemStack.method_7914()))))) {
            PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotEnoughSpace().replace("%amount%", String.valueOf(amount)).replace("%slots%", String.valueOf(slotsNeeded)), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
            return false;
        }
        BigDecimal totalBuy = this.getBuyPrice(player, amount, shop, config);
        if (EconomyApi.hasEnoughMoney((UUID)player.method_5667(), (BigDecimal)totalBuy, (EconomyUse)shop.getEconomy(), (boolean)true)) {
            ItemChance.giveReward((class_3222)player, (ItemChance)itemChance, (int)amount);
            result = true;
        }
        if (!result) {
            PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotEnoughMoney().replace("%product%", itemChance.getTitle()).replace("%amount%", String.valueOf(amount)).replace("%pack%", "" + itemChance.getItemStack().method_7947()).replace("%price%", EconomyApi.formatMoney((BigDecimal)totalBuy, (EconomyUse)shop.getEconomy())), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
        } else {
            if (this.getUuid() != null) {
                DataBaseFactory.INSTANCE.addProductLimit(player, shop, this, amount);
            }
            if (ShopApi.getMainConfig().isSaveTransactions()) {
                DataBaseFactory.INSTANCE.addTransaction(player, shop, this, ActionShop.BUY, amount, totalBuy);
            }
        }
        Config.manageOpenShop(player, options, config, null, stack, null, withClose);
        return result;
    }

    public boolean hasErrors() {
        if (this.buy != null && this.sell != null && this.buy.compareTo(BigDecimal.ZERO) > 0 && this.sell.compareTo(BigDecimal.ZERO) > 0 && this.buy.compareTo(this.sell) < 0) {
            CobbleUtils.LOGGER.error("The sell price is lower than the buy price -> " + this.product);
            return true;
        }
        return false;
    }

    public int getStack() {
        if (this.product.startsWith("command:") || this.product.startsWith("pokemon:") || this.oneByOne != null && this.oneByOne.booleanValue()) {
            return 1;
        }
        return new ItemChance(this.product, 0).getItemStack().method_7914();
    }

    public boolean canSell(class_3222 player, Shop shop, ShopOptionsApi options) {
        if (this.getSell() == null || this.getSell().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        if (player != null) {
            class_1799 itemStack = this.getItemStack();
            if (itemStack.method_7960()) {
                return false;
            }
            BigDecimal buyPrice = this.getBuyPrice(player, 1, shop, ShopApi.getConfig(options));
            BigDecimal sellPricePerUnit = this.getSellPricePerUnit(itemStack);
            boolean canSell = buyPrice.compareTo(BigDecimal.ZERO) <= 0 || buyPrice.compareTo(sellPricePerUnit) >= 0;
            return canSell;
        }
        return !this.product.startsWith("command:") && !this.product.startsWith("pokemon:") && this.sell.compareTo(BigDecimal.ZERO) > 0 && !this.product.contains("|");
    }

    public class_1799 getItemStack() {
        return new ItemChance(this.product, 0).getItemStack();
    }

    public void sell(class_3222 player, Shop shop, int amount, Product product, ShopOptionsApi options, Config config, Stack<Shop> stack, boolean withClose) {
        class_1799 productItemStack = product.getItemStack();
        BigDecimal sellPricePerUnit = product.getSellPricePerUnit(productItemStack);
        BigDecimal total = BigDecimal.ZERO;
        class_1661 playerInventory = player.method_31548();
        int remainingAmount = amount;
        int selled = 0;
        for (class_1799 itemStack : playerInventory.field_7547) {
            if (Product.areEquals(itemStack, productItemStack)) {
                int stackCount = itemStack.method_7947();
                if (stackCount >= remainingAmount) {
                    itemStack.method_7934(remainingAmount);
                    selled += remainingAmount;
                    total = total.add(sellPricePerUnit.multiply(BigDecimal.valueOf(remainingAmount)));
                    remainingAmount = 0;
                    break;
                }
                remainingAmount -= stackCount;
                selled += stackCount;
                itemStack.method_7934(stackCount);
                total = total.add(sellPricePerUnit.multiply(BigDecimal.valueOf(stackCount)));
            }
            if (remainingAmount > 0) continue;
            break;
        }
        EconomyApi.addMoney((UUID)player.method_5667(), (BigDecimal)total, (EconomyUse)shop.getEconomy());
        PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageSimpleSell().replace("%product%", productItemStack.method_7964().getString()).replace("%amount%", String.valueOf(selled)).replace("%price%", EconomyApi.formatMoney((BigDecimal)total, (EconomyUse)shop.getEconomy())), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
        if (ShopApi.getMainConfig().isSaveTransactions()) {
            DataBaseFactory.INSTANCE.addTransaction(player, shop, product, ActionShop.SELL, selled, total);
        }
        Config.manageOpenShop(player, options, config, null, stack, null, withClose);
    }

    public static BigDecimal sellProduct(Shop shop, class_1799 itemStack, Product product) {
        class_1799 itemProduct = product.getItemStack();
        if (Product.areEquals(itemStack, itemProduct)) {
            int itemStackCount = itemStack.method_7947();
            int itemProductCount = itemProduct.method_7947();
            if (itemProductCount <= 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal totalSellPrice = product.getSellPrice(itemStackCount);
            BigDecimal adjustedPrice = totalSellPrice.divide(BigDecimal.valueOf(itemProductCount), 5, RoundingMode.UNNECESSARY);
            if (adjustedPrice.compareTo(BigDecimal.ZERO) <= 0) {
                return BigDecimal.ZERO;
            }
            itemStack.method_7934(itemStackCount);
            return adjustedPrice;
        }
        return BigDecimal.ZERO;
    }

    public static boolean areEquals(class_1799 itemStack, class_1799 itemProduct) {
        boolean ItemEqual = class_1799.method_7984((class_1799)itemStack, (class_1799)itemProduct);
        class_9280 a = (class_9280)itemStack.method_57824(class_9334.field_49637);
        int aNumber = a == null ? 0 : a.comp_2382();
        class_9280 b = (class_9280)itemProduct.method_57824(class_9334.field_49637);
        int bNumber = b == null ? 0 : b.comp_2382();
        boolean CustomModelDataEqual = aNumber == bNumber;
        return ItemEqual && CustomModelDataEqual;
    }

    @Generated
    public Boolean getOneByOne() {
        return this.oneByOne;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public Integer getMax() {
        return this.max;
    }

    @Generated
    public Integer getCooldown() {
        return this.cooldown;
    }

    @Generated
    public String getCanBuyPermission() {
        return this.canBuyPermission;
    }

    @Generated
    public String getNotBuyPermission() {
        return this.notBuyPermission;
    }

    @Generated
    public Float getDiscount() {
        return this.discount;
    }

    @Generated
    public String getDisplay() {
        return this.display;
    }

    @Generated
    public String getDisplayname() {
        return this.displayname;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public Integer getCustomModelData() {
        return this.CustomModelData;
    }

    @Generated
    public Integer getSlot() {
        return this.slot;
    }

    @Generated
    public String getProduct() {
        return this.product;
    }

    @Generated
    public BigDecimal getBuy() {
        return this.buy;
    }

    @Generated
    public BigDecimal getSell() {
        return this.sell;
    }

    @Generated
    public void setOneByOne(Boolean oneByOne) {
        this.oneByOne = oneByOne;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMax(Integer max) {
        this.max = max;
    }

    @Generated
    public void setCooldown(Integer cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setCanBuyPermission(String canBuyPermission) {
        this.canBuyPermission = canBuyPermission;
    }

    @Generated
    public void setNotBuyPermission(String notBuyPermission) {
        this.notBuyPermission = notBuyPermission;
    }

    @Generated
    public void setDiscount(Float discount) {
        this.discount = discount;
    }

    @Generated
    public void setDisplay(String display) {
        this.display = display;
    }

    @Generated
    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    @Generated
    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Generated
    public void setCustomModelData(Integer CustomModelData) {
        this.CustomModelData = CustomModelData;
    }

    @Generated
    public void setSlot(Integer slot) {
        this.slot = slot;
    }

    @Generated
    public void setProduct(String product) {
        this.product = product;
    }

    @Generated
    public void setBuy(BigDecimal buy) {
        this.buy = buy;
    }

    @Generated
    public void setSell(BigDecimal sell) {
        this.sell = sell;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$oneByOne = this.getOneByOne();
        Boolean other$oneByOne = other.getOneByOne();
        if (this$oneByOne == null ? other$oneByOne != null : !((Object)this$oneByOne).equals(other$oneByOne)) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        Integer this$cooldown = this.getCooldown();
        Integer other$cooldown = other.getCooldown();
        if (this$cooldown == null ? other$cooldown != null : !((Object)this$cooldown).equals(other$cooldown)) {
            return false;
        }
        Float this$discount = this.getDiscount();
        Float other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Integer this$CustomModelData = this.getCustomModelData();
        Integer other$CustomModelData = other.getCustomModelData();
        if (this$CustomModelData == null ? other$CustomModelData != null : !((Object)this$CustomModelData).equals(other$CustomModelData)) {
            return false;
        }
        Integer this$slot = this.getSlot();
        Integer other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$canBuyPermission = this.getCanBuyPermission();
        String other$canBuyPermission = other.getCanBuyPermission();
        if (this$canBuyPermission == null ? other$canBuyPermission != null : !this$canBuyPermission.equals(other$canBuyPermission)) {
            return false;
        }
        String this$notBuyPermission = this.getNotBuyPermission();
        String other$notBuyPermission = other.getNotBuyPermission();
        if (this$notBuyPermission == null ? other$notBuyPermission != null : !this$notBuyPermission.equals(other$notBuyPermission)) {
            return false;
        }
        String this$display = this.getDisplay();
        String other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        String this$displayname = this.getDisplayname();
        String other$displayname = other.getDisplayname();
        if (this$displayname == null ? other$displayname != null : !this$displayname.equals(other$displayname)) {
            return false;
        }
        List<String> this$lore = this.getLore();
        List<String> other$lore = other.getLore();
        if (this$lore == null ? other$lore != null : !((Object)this$lore).equals(other$lore)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        BigDecimal this$buy = this.getBuy();
        BigDecimal other$buy = other.getBuy();
        if (this$buy == null ? other$buy != null : !((Object)this$buy).equals(other$buy)) {
            return false;
        }
        BigDecimal this$sell = this.getSell();
        BigDecimal other$sell = other.getSell();
        return !(this$sell == null ? other$sell != null : !((Object)this$sell).equals(other$sell));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $oneByOne = this.getOneByOne();
        result = result * 59 + ($oneByOne == null ? 43 : ((Object)$oneByOne).hashCode());
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        Integer $cooldown = this.getCooldown();
        result = result * 59 + ($cooldown == null ? 43 : ((Object)$cooldown).hashCode());
        Float $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Integer $CustomModelData = this.getCustomModelData();
        result = result * 59 + ($CustomModelData == null ? 43 : ((Object)$CustomModelData).hashCode());
        Integer $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $canBuyPermission = this.getCanBuyPermission();
        result = result * 59 + ($canBuyPermission == null ? 43 : $canBuyPermission.hashCode());
        String $notBuyPermission = this.getNotBuyPermission();
        result = result * 59 + ($notBuyPermission == null ? 43 : $notBuyPermission.hashCode());
        String $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        String $displayname = this.getDisplayname();
        result = result * 59 + ($displayname == null ? 43 : $displayname.hashCode());
        List<String> $lore = this.getLore();
        result = result * 59 + ($lore == null ? 43 : ((Object)$lore).hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        BigDecimal $buy = this.getBuy();
        result = result * 59 + ($buy == null ? 43 : ((Object)$buy).hashCode());
        BigDecimal $sell = this.getSell();
        result = result * 59 + ($sell == null ? 43 : ((Object)$sell).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Product(oneByOne=" + this.getOneByOne() + ", uuid=" + String.valueOf(this.getUuid()) + ", max=" + this.getMax() + ", cooldown=" + this.getCooldown() + ", canBuyPermission=" + this.getCanBuyPermission() + ", notBuyPermission=" + this.getNotBuyPermission() + ", discount=" + this.getDiscount() + ", display=" + this.getDisplay() + ", displayname=" + this.getDisplayname() + ", lore=" + String.valueOf(this.getLore()) + ", CustomModelData=" + this.getCustomModelData() + ", slot=" + this.getSlot() + ", product=" + this.getProduct() + ", buy=" + String.valueOf(this.getBuy()) + ", sell=" + String.valueOf(this.getSell()) + ")";
    }

    public static class SellProduct {
        private String currency;
        private BigDecimal price;

        public SellProduct(String currency, BigDecimal price) {
            this.currency = currency;
            this.price = price;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public BigDecimal getPrice() {
            return this.price;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SellProduct)) {
                return false;
            }
            SellProduct other = (SellProduct)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$price = this.getPrice();
            BigDecimal other$price = other.getPrice();
            return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SellProduct;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Product.SellProduct(currency=" + this.getCurrency() + ", price=" + String.valueOf(this.getPrice()) + ")";
        }
    }
}

