/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.models;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.button.linked.LinkType;
import ca.landonjw.gooeylibs2.api.button.linked.LinkedPageButton;
import ca.landonjw.gooeylibs2.api.helpers.PaginationHelper;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.page.LinkedPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.EconomyUse;
import com.kingpixel.cobbleutils.Model.ItemChance;
import com.kingpixel.cobbleutils.Model.ItemModel;
import com.kingpixel.cobbleutils.Model.PanelsConfig;
import com.kingpixel.cobbleutils.Model.Rectangle;
import com.kingpixel.cobbleutils.Model.Sound;
import com.kingpixel.cobbleutils.api.EconomyApi;
import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.cobbleutils.util.TypeMessage;
import com.kingpixel.cobbleutils.util.UIUtils;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.SubShop;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.class_3222;

public class Shop {
    private String Path;
    private boolean autoPlace = true;
    private String id;
    private String title;
    private EconomyUse economy;
    private String closeCommand;
    private String soundOpen;
    private String soundClose;
    private String colorProduct;
    private int rows;
    private float globalDiscount;
    private ShopType type;
    private Rectangle rectangle;
    private Map<String, Float> discounts;
    private ItemModel display;
    private ItemModel itemInfoShop;
    private ItemModel itemBalance;
    private List<SubShop> subShops;
    private List<Product> products;
    private ItemModel itemPrevious;
    private ItemModel itemClose;
    private ItemModel itemNext;
    private List<PanelsConfig> panels;

    public Shop() {
        this.id = "shop";
        this.title = "%shop%";
        this.closeCommand = "";
        this.colorProduct = "";
        this.soundOpen = "minecraft:block.chest.open";
        this.soundClose = "minecraft:block.chest.close";
        this.rows = 6;
        this.globalDiscount = 0.0f;
        this.type = new ShopTypePermanent();
        this.discounts = new HashMap<String, Float>();
        this.discounts.put("group.vip", Float.valueOf(2.0f));
        this.rectangle = new Rectangle(1, 1, 4, 7);
        this.display = new ItemModel("");
        this.itemInfoShop = new ItemModel("");
        this.itemInfoShop.setSlot(Integer.valueOf(51));
        this.itemBalance = new ItemModel("");
        this.itemBalance.setSlot(Integer.valueOf(47));
        this.products = this.getDefaultProducts();
        this.itemPrevious = new ItemModel("");
        this.itemPrevious.setSlot(Integer.valueOf(45));
        this.itemClose = new ItemModel("");
        this.itemClose.setSlot(Integer.valueOf(49));
        this.itemNext = new ItemModel("");
        this.itemNext.setSlot(Integer.valueOf(53));
        this.panels = List.of(new PanelsConfig(new ItemModel("minecraft:gray_stained_glass_pane"), this.rows));
    }

    public Shop(String id, ShopType type) {
        this.id = id;
        this.title = "%shop%";
        this.closeCommand = "";
        this.soundOpen = "block.chest.open";
        this.soundClose = "block.chest.close";
        this.rows = 6;
        this.globalDiscount = 0.0f;
        this.type = type;
        this.discounts = new HashMap<String, Float>();
        this.discounts.put("group.vip", Float.valueOf(2.0f));
        this.subShops = new ArrayList<SubShop>();
        this.rectangle = new Rectangle(1, 1, 4, 7);
        this.display = new ItemModel("");
        this.itemInfoShop = new ItemModel("");
        this.itemInfoShop.setSlot(Integer.valueOf(51));
        this.itemBalance = new ItemModel("");
        this.itemBalance.setSlot(Integer.valueOf(47));
        this.products = this.getDefaultProducts();
        this.itemPrevious = new ItemModel("");
        this.itemPrevious.setSlot(Integer.valueOf(45));
        this.itemClose = new ItemModel("");
        this.itemClose.setSlot(Integer.valueOf(49));
        this.itemNext = new ItemModel("");
        this.itemNext.setSlot(Integer.valueOf(53));
        this.panels = List.of(new PanelsConfig(new ItemModel("minecraft:gray_stained_glass_pane"), this.rows));
    }

    private void write(ShopOptionsApi options) {
        CompletableFuture futureWrite = Utils.writeFileAsync((String)this.getPath(), (String)(this.getId() + ".json"), (String)UltraShop.gson.toJson((Object)this));
        if (!((Boolean)futureWrite.join()).booleanValue()) {
            CobbleUtils.LOGGER.error("Error writing file: " + this.getPath() + this.getId() + ".json");
        }
        UltraShop.load(options);
    }

    private Product from(ItemChance itemChance) {
        Product product = new Product();
        product.setProduct(itemChance.getItem());
        product.setDisplay(itemChance.getDisplay());
        return product;
    }

    private List<Product> getDefaultProducts() {
        List itemChances = ItemChance.defaultItemChances();
        ArrayList<Product> products = new ArrayList<Product>();
        for (ItemChance itemChance : itemChances) {
            products.add(this.from(itemChance));
        }
        products.add(new Product(true));
        return products;
    }

    public void check() {
        if (this.subShops == null) {
            this.subShops = new ArrayList<SubShop>();
        }
        if (this.economy == null) {
            this.economy = new EconomyUse("IMPACTOR", "impactor:dollars");
        }
        this.products.forEach(product -> product.check(this));
        this.type.check();
    }

    public String getPermission(ShopOptionsApi options) {
        String modId = options.getModId().equals("ultrashop") ? "ultrashop" : options.getModId() + ".shop";
        return modId + ".shops." + this.id;
    }

    public void open(class_3222 player, ShopOptionsApi options, Config config, int position, Stack<Shop> shop, boolean withClose) {
        CompletableFuture.runAsync(() -> {
            try {
                GooeyPage page;
                if (!PermissionApi.hasPermission((class_3222)player, (String)this.getPermission(options), (int)4)) {
                    PlayerUtils.sendMessage((class_3222)player, (String)UltraShop.lang.getMessageNotHavePermission().replace("%shop%", this.title).replace("%permission%", this.getPermission(options)), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                    return;
                }
                ChestTemplate template = ChestTemplate.builder((int)this.rows).build();
                PanelsConfig.applyConfig((ChestTemplate)template, this.getPanels(), (int)this.rows);
                BigDecimal balance = EconomyApi.getBalance((UUID)player.method_5667(), (EconomyUse)this.economy);
                String playerBalance = EconomyApi.formatMoney((BigDecimal)balance, (EconomyUse)this.economy);
                int totalSlots = this.rectangle.getLength() * this.rectangle.getWidth();
                List<Product> products = this.type.getProducts(this, options);
                int totalProducts = products.size();
                int totalSubShops = this.subShops.size();
                boolean hasEnoughtButtons = this.subShops.isEmpty() ? totalProducts > totalSlots : totalSubShops > totalSlots;
                ArrayList<GooeyButton> buttons = new ArrayList<GooeyButton>();
                if (this.subShops.isEmpty()) {
                    if (hasEnoughtButtons || this.autoPlace) {
                        for (Product product : products) {
                            if (product.hasErrors()) continue;
                            buttons.add(product.getIcon(player, shop, null, 1, options, config, withClose, playerBalance));
                        }
                    } else {
                        for (Product product : products) {
                            Integer slot = product.getSlot();
                            if (slot == null) {
                                CobbleUtils.LOGGER.error(options.getModId(), "Slot is null -> " + product.getProduct());
                                continue;
                            }
                            TemplateSlotDelegate templateSlotDelegate = template.getSlot(slot.intValue());
                            if (templateSlotDelegate != null) {
                                if (!UIUtils.isInside((int)slot, (int)this.rows)) continue;
                                template.set(slot.intValue(), (Button)product.getIcon(player, shop, null, 1, options, config, withClose, playerBalance));
                                continue;
                            }
                            CobbleUtils.LOGGER.error(options.getModId(), "Slot has a product or button -> " + slot + " Product -> " + product.getProduct());
                            PlayerUtils.sendMessage((class_3222)player, (String)("Slot has a product or button -> " + slot + " Product -> " + product.getProduct()), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
                        }
                    }
                } else if (this.autoPlace) {
                    this.subShops.forEach(subShop -> buttons.add(this.getSubShopButton(options, (SubShop)subShop, player, config, shop, withClose)));
                } else {
                    this.subShops.forEach(subShop -> {
                        if (UIUtils.isInside((int)subShop.getSlot(), (int)this.rows)) {
                            template.set(subShop.getSlot(), (Button)this.getSubShopButton(options, (SubShop)subShop, player, config, shop, withClose));
                        }
                    });
                }
                if (UIUtils.isInside((int)this.itemInfoShop.getSlot(), (int)this.rows)) {
                    template.set(this.itemInfoShop.getSlot().intValue(), (Button)UltraShop.lang.getInfoShopType().getShopType(this, options, this.getItemInfoShop()));
                }
                if (UIUtils.isInside((int)this.itemBalance.getSlot(), (int)this.rows)) {
                    ItemModel itemBalance = UltraShop.lang.getGlobalItemBalance(this.itemBalance);
                    String format = EconomyApi.formatMoney((BigDecimal)balance, (EconomyUse)this.economy);
                    String nameBalance = itemBalance.getDisplayname().replace("%balance%", format).replace("%currency%", this.economy.getCurrency()).replace("%amount%", format);
                    ArrayList lore = new ArrayList(itemBalance.getLore());
                    lore.replaceAll(s -> s.replace("%balance%", format).replace("%currency%", this.economy.getCurrency()).replace("%amount%", format));
                    template.set(this.itemBalance.getSlot().intValue(), (Button)itemBalance.getButton(1, nameBalance, lore, action -> {}));
                }
                if (UIUtils.isInside((int)this.itemClose.getSlot(), (int)this.rows) && withClose) {
                    ItemModel itemClose = UltraShop.lang.getGlobalItemClose(this.itemClose);
                    GooeyButton closeButton = itemClose.getButton(1, action -> {
                        if (!this.getCloseCommand().isEmpty()) {
                            PlayerUtils.executeCommand((String)this.getCloseCommand(), (class_3222)player);
                            return;
                        }
                        Config.manageOpenShop(player, options, config, null, shop, this, withClose);
                    });
                    template.set(this.itemClose.getSlot().intValue(), (Button)closeButton);
                }
                if (hasEnoughtButtons) {
                    if (UIUtils.isInside((int)this.itemPrevious.getSlot(), (int)this.rows)) {
                        ItemModel previous = UltraShop.lang.getGlobalItemPrevious(this.itemPrevious);
                        template.set(this.itemPrevious.getSlot().intValue(), (Button)LinkedPageButton.builder().display(previous.getItemStack()).linkType(LinkType.Previous).build());
                    }
                    if (UIUtils.isInside((int)this.itemNext.getSlot(), (int)this.rows)) {
                        ItemModel next = UltraShop.lang.getGlobalItemNext(this.itemNext);
                        template.set(this.itemNext.getSlot().intValue(), (Button)LinkedPageButton.builder().display(next.getItemStack()).linkType(LinkType.Next).build());
                    }
                }
                this.title = this.title.replace("%shop%", this.id);
                if (hasEnoughtButtons || this.autoPlace) {
                    this.rectangle.apply(template);
                    LinkedPage.Builder linkedPage = LinkedPage.builder().template((Template)template).onOpen(action -> new Sound(this.soundOpen).playSoundPlayer(action.getPlayer())).title(AdventureTranslator.toNative((String)this.title));
                    page = PaginationHelper.createPagesFromPlaceholders((Template)template, buttons, (LinkedPage.Builder)linkedPage);
                } else {
                    page = GooeyPage.builder().template((Template)template).onOpen(action -> new Sound(this.soundOpen).playSoundPlayer(player)).build();
                    page.setTitle(AdventureTranslator.toNative((String)this.title));
                }
                UIManager.openUIForcefully((class_3222)player, (Page)page);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerUtils.sendMessage((class_3222)player, (String)("Please contact the server administrator to report this error. The administrator needs to check the console. Shop -> " + this.id + " Mod -> " + options.getModId()), (String)UltraShop.lang.getPrefix(), (TypeMessage)TypeMessage.CHAT);
            }
        }, UltraShop.SHOP_EXECUTOR).orTimeout(5L, TimeUnit.SECONDS).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    private GooeyButton getSubShopButton(ShopOptionsApi options, SubShop subShop, class_3222 player, Config config, Stack<Shop> shop, boolean withClose) {
        Shop category = ShopApi.getShop(options, subShop.getIdShop());
        if (category == null) {
            CobbleUtils.LOGGER.info("ultrashop", "Not Found the shop with id -> " + subShop.getIdShop());
            return null;
        }
        ItemModel display = UltraShop.lang.getGlobalDisplay(category.getDisplay());
        ArrayList lore = new ArrayList(display.getLore());
        return display.getButton(1, display.getDisplayname().replace("%shop%", category.getId()), lore, action -> Config.manageOpenShop(player, options, config, category, shop, this, withClose));
    }

    @Generated
    public String getPath() {
        return this.Path;
    }

    @Generated
    public boolean isAutoPlace() {
        return this.autoPlace;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public EconomyUse getEconomy() {
        return this.economy;
    }

    @Generated
    public String getCloseCommand() {
        return this.closeCommand;
    }

    @Generated
    public String getSoundOpen() {
        return this.soundOpen;
    }

    @Generated
    public String getSoundClose() {
        return this.soundClose;
    }

    @Generated
    public String getColorProduct() {
        return this.colorProduct;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public float getGlobalDiscount() {
        return this.globalDiscount;
    }

    @Generated
    public ShopType getType() {
        return this.type;
    }

    @Generated
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Generated
    public Map<String, Float> getDiscounts() {
        return this.discounts;
    }

    @Generated
    public ItemModel getDisplay() {
        return this.display;
    }

    @Generated
    public ItemModel getItemInfoShop() {
        return this.itemInfoShop;
    }

    @Generated
    public ItemModel getItemBalance() {
        return this.itemBalance;
    }

    @Generated
    public List<SubShop> getSubShops() {
        return this.subShops;
    }

    @Generated
    public List<Product> getProducts() {
        return this.products;
    }

    @Generated
    public ItemModel getItemPrevious() {
        return this.itemPrevious;
    }

    @Generated
    public ItemModel getItemClose() {
        return this.itemClose;
    }

    @Generated
    public ItemModel getItemNext() {
        return this.itemNext;
    }

    @Generated
    public List<PanelsConfig> getPanels() {
        return this.panels;
    }

    @Generated
    public void setPath(String Path2) {
        this.Path = Path2;
    }

    @Generated
    public void setAutoPlace(boolean autoPlace) {
        this.autoPlace = autoPlace;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setEconomy(EconomyUse economy) {
        this.economy = economy;
    }

    @Generated
    public void setCloseCommand(String closeCommand) {
        this.closeCommand = closeCommand;
    }

    @Generated
    public void setSoundOpen(String soundOpen) {
        this.soundOpen = soundOpen;
    }

    @Generated
    public void setSoundClose(String soundClose) {
        this.soundClose = soundClose;
    }

    @Generated
    public void setColorProduct(String colorProduct) {
        this.colorProduct = colorProduct;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public void setGlobalDiscount(float globalDiscount) {
        this.globalDiscount = globalDiscount;
    }

    @Generated
    public void setType(ShopType type) {
        this.type = type;
    }

    @Generated
    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Generated
    public void setDiscounts(Map<String, Float> discounts) {
        this.discounts = discounts;
    }

    @Generated
    public void setDisplay(ItemModel display) {
        this.display = display;
    }

    @Generated
    public void setItemInfoShop(ItemModel itemInfoShop) {
        this.itemInfoShop = itemInfoShop;
    }

    @Generated
    public void setItemBalance(ItemModel itemBalance) {
        this.itemBalance = itemBalance;
    }

    @Generated
    public void setSubShops(List<SubShop> subShops) {
        this.subShops = subShops;
    }

    @Generated
    public void setProducts(List<Product> products) {
        this.products = products;
    }

    @Generated
    public void setItemPrevious(ItemModel itemPrevious) {
        this.itemPrevious = itemPrevious;
    }

    @Generated
    public void setItemClose(ItemModel itemClose) {
        this.itemClose = itemClose;
    }

    @Generated
    public void setItemNext(ItemModel itemNext) {
        this.itemNext = itemNext;
    }

    @Generated
    public void setPanels(List<PanelsConfig> panels) {
        this.panels = panels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shop)) {
            return false;
        }
        Shop other = (Shop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoPlace() != other.isAutoPlace()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (Float.compare(this.getGlobalDiscount(), other.getGlobalDiscount()) != 0) {
            return false;
        }
        String this$Path = this.getPath();
        String other$Path = other.getPath();
        if (this$Path == null ? other$Path != null : !this$Path.equals(other$Path)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        EconomyUse this$economy = this.getEconomy();
        EconomyUse other$economy = other.getEconomy();
        if (this$economy == null ? other$economy != null : !this$economy.equals(other$economy)) {
            return false;
        }
        String this$closeCommand = this.getCloseCommand();
        String other$closeCommand = other.getCloseCommand();
        if (this$closeCommand == null ? other$closeCommand != null : !this$closeCommand.equals(other$closeCommand)) {
            return false;
        }
        String this$soundOpen = this.getSoundOpen();
        String other$soundOpen = other.getSoundOpen();
        if (this$soundOpen == null ? other$soundOpen != null : !this$soundOpen.equals(other$soundOpen)) {
            return false;
        }
        String this$soundClose = this.getSoundClose();
        String other$soundClose = other.getSoundClose();
        if (this$soundClose == null ? other$soundClose != null : !this$soundClose.equals(other$soundClose)) {
            return false;
        }
        String this$colorProduct = this.getColorProduct();
        String other$colorProduct = other.getColorProduct();
        if (this$colorProduct == null ? other$colorProduct != null : !this$colorProduct.equals(other$colorProduct)) {
            return false;
        }
        ShopType this$type = this.getType();
        ShopType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Rectangle this$rectangle = this.getRectangle();
        Rectangle other$rectangle = other.getRectangle();
        if (this$rectangle == null ? other$rectangle != null : !this$rectangle.equals(other$rectangle)) {
            return false;
        }
        Map<String, Float> this$discounts = this.getDiscounts();
        Map<String, Float> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        ItemModel this$display = this.getDisplay();
        ItemModel other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        ItemModel this$itemInfoShop = this.getItemInfoShop();
        ItemModel other$itemInfoShop = other.getItemInfoShop();
        if (this$itemInfoShop == null ? other$itemInfoShop != null : !this$itemInfoShop.equals(other$itemInfoShop)) {
            return false;
        }
        ItemModel this$itemBalance = this.getItemBalance();
        ItemModel other$itemBalance = other.getItemBalance();
        if (this$itemBalance == null ? other$itemBalance != null : !this$itemBalance.equals(other$itemBalance)) {
            return false;
        }
        List<SubShop> this$subShops = this.getSubShops();
        List<SubShop> other$subShops = other.getSubShops();
        if (this$subShops == null ? other$subShops != null : !((Object)this$subShops).equals(other$subShops)) {
            return false;
        }
        List<Product> this$products = this.getProducts();
        List<Product> other$products = other.getProducts();
        if (this$products == null ? other$products != null : !((Object)this$products).equals(other$products)) {
            return false;
        }
        ItemModel this$itemPrevious = this.getItemPrevious();
        ItemModel other$itemPrevious = other.getItemPrevious();
        if (this$itemPrevious == null ? other$itemPrevious != null : !this$itemPrevious.equals(other$itemPrevious)) {
            return false;
        }
        ItemModel this$itemClose = this.getItemClose();
        ItemModel other$itemClose = other.getItemClose();
        if (this$itemClose == null ? other$itemClose != null : !this$itemClose.equals(other$itemClose)) {
            return false;
        }
        ItemModel this$itemNext = this.getItemNext();
        ItemModel other$itemNext = other.getItemNext();
        if (this$itemNext == null ? other$itemNext != null : !this$itemNext.equals(other$itemNext)) {
            return false;
        }
        List<PanelsConfig> this$panels = this.getPanels();
        List<PanelsConfig> other$panels = other.getPanels();
        return !(this$panels == null ? other$panels != null : !((Object)this$panels).equals(other$panels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Shop;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoPlace() ? 79 : 97);
        result = result * 59 + this.getRows();
        result = result * 59 + Float.floatToIntBits(this.getGlobalDiscount());
        String $Path = this.getPath();
        result = result * 59 + ($Path == null ? 43 : $Path.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        EconomyUse $economy = this.getEconomy();
        result = result * 59 + ($economy == null ? 43 : $economy.hashCode());
        String $closeCommand = this.getCloseCommand();
        result = result * 59 + ($closeCommand == null ? 43 : $closeCommand.hashCode());
        String $soundOpen = this.getSoundOpen();
        result = result * 59 + ($soundOpen == null ? 43 : $soundOpen.hashCode());
        String $soundClose = this.getSoundClose();
        result = result * 59 + ($soundClose == null ? 43 : $soundClose.hashCode());
        String $colorProduct = this.getColorProduct();
        result = result * 59 + ($colorProduct == null ? 43 : $colorProduct.hashCode());
        ShopType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Rectangle $rectangle = this.getRectangle();
        result = result * 59 + ($rectangle == null ? 43 : $rectangle.hashCode());
        Map<String, Float> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        ItemModel $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        ItemModel $itemInfoShop = this.getItemInfoShop();
        result = result * 59 + ($itemInfoShop == null ? 43 : $itemInfoShop.hashCode());
        ItemModel $itemBalance = this.getItemBalance();
        result = result * 59 + ($itemBalance == null ? 43 : $itemBalance.hashCode());
        List<SubShop> $subShops = this.getSubShops();
        result = result * 59 + ($subShops == null ? 43 : ((Object)$subShops).hashCode());
        List<Product> $products = this.getProducts();
        result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
        ItemModel $itemPrevious = this.getItemPrevious();
        result = result * 59 + ($itemPrevious == null ? 43 : $itemPrevious.hashCode());
        ItemModel $itemClose = this.getItemClose();
        result = result * 59 + ($itemClose == null ? 43 : $itemClose.hashCode());
        ItemModel $itemNext = this.getItemNext();
        result = result * 59 + ($itemNext == null ? 43 : $itemNext.hashCode());
        List<PanelsConfig> $panels = this.getPanels();
        result = result * 59 + ($panels == null ? 43 : ((Object)$panels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Shop(Path=" + this.getPath() + ", autoPlace=" + this.isAutoPlace() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", economy=" + String.valueOf(this.getEconomy()) + ", closeCommand=" + this.getCloseCommand() + ", soundOpen=" + this.getSoundOpen() + ", soundClose=" + this.getSoundClose() + ", colorProduct=" + this.getColorProduct() + ", rows=" + this.getRows() + ", globalDiscount=" + this.getGlobalDiscount() + ", type=" + String.valueOf(this.getType()) + ", rectangle=" + String.valueOf(this.getRectangle()) + ", discounts=" + String.valueOf(this.getDiscounts()) + ", display=" + String.valueOf(this.getDisplay()) + ", itemInfoShop=" + String.valueOf(this.getItemInfoShop()) + ", itemBalance=" + String.valueOf(this.getItemBalance()) + ", subShops=" + String.valueOf(this.getSubShops()) + ", products=" + String.valueOf(this.getProducts()) + ", itemPrevious=" + String.valueOf(this.getItemPrevious()) + ", itemClose=" + String.valueOf(this.getItemClose()) + ", itemNext=" + String.valueOf(this.getItemNext()) + ", panels=" + String.valueOf(this.getPanels()) + ")";
    }
}

