/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.models;

import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.database.DataBaseFactory;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.ProductLimit;
import com.kingpixel.ultrashop.models.ProductTransaction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.class_3222;

public class UserInfo {
    private UUID uuid;
    private String name;
    private Map<UUID, ProductLimit> cooldownProduct = new HashMap<UUID, ProductLimit>();
    private List<ProductTransaction> transactions = new ArrayList<ProductTransaction>();

    public UserInfo(class_3222 player) {
        this.uuid = player.method_5667();
        this.name = player.method_7334().getName();
    }

    public void read(class_3222 player) {
        CompletableFuture futureRead;
        File folder = Utils.getAbsolutePath((String)"/config/ultrashop/data/users/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!((Boolean)(futureRead = Utils.readFileAsync((String)"/config/ultrashop/data/users/", (String)(player.method_5845() + ".json"), call -> {
            UserInfo userInfo = (UserInfo)UltraShop.gson.fromJson(call, UserInfo.class);
            userInfo.check(true);
            DataBaseFactory.users.put(player.method_5667(), userInfo);
        })).join()).booleanValue()) {
            String data = UltraShop.gsonWithOutSpaces.toJson((Object)this);
            Utils.writeFileAsync((File)Utils.getAbsolutePath((String)("/config/ultrashop/data/users/" + player.method_5845() + ".json")), (String)data);
        }
    }

    public void check(boolean strong) {
        boolean save = false;
        if (strong && !this.getCooldownProduct().isEmpty()) {
            ArrayList toRemove = new ArrayList();
            this.getCooldownProduct().forEach((uuid, productLimit) -> {
                boolean exists = ShopApi.shops.values().stream().flatMap(Collection::stream).flatMap(shop -> shop.getProducts().stream()).anyMatch(product -> {
                    UUID productUuid = product.getUuid();
                    return productUuid != null && productUuid.equals(uuid);
                });
                if (!exists) {
                    toRemove.add(uuid);
                }
            });
            toRemove.forEach(uuid -> this.getCooldownProduct().remove(uuid));
            if (!toRemove.isEmpty()) {
                save = true;
            }
        }
        if (save) {
            DataBaseFactory.INSTANCE.updateUserInfo(this);
        }
    }

    public int getActualProductLimit(Product product) {
        ProductLimit productLimit = this.cooldownProduct.get(product.getUuid());
        if (productLimit == null) {
            return 0;
        }
        return productLimit.getAmount();
    }

    public void addProductLimit(Product product, int amount) {
        ProductLimit productLimit = this.cooldownProduct.get(product.getUuid());
        if (productLimit == null) {
            productLimit = new ProductLimit();
            productLimit.setUuid(product.getUuid());
            productLimit.setCooldown(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(product.getCooldown().intValue()));
            productLimit.setAmount(amount);
            this.cooldownProduct.put(product.getUuid(), productLimit);
        } else {
            productLimit.setAmount(productLimit.getAmount() + amount);
        }
        DataBaseFactory.INSTANCE.updateUserInfo(this);
    }

    public void write(class_3222 player) {
        String data = UltraShop.gsonWithOutSpaces.toJson((Object)this);
        Utils.writeFileAsync((File)Utils.getAbsolutePath((String)("/config/ultrashop/data/users/" + player.method_5845() + ".json")), (String)data);
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<UUID, ProductLimit> getCooldownProduct() {
        return this.cooldownProduct;
    }

    @Generated
    public List<ProductTransaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCooldownProduct(Map<UUID, ProductLimit> cooldownProduct) {
        this.cooldownProduct = cooldownProduct;
    }

    @Generated
    public void setTransactions(List<ProductTransaction> transactions) {
        this.transactions = transactions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<UUID, ProductLimit> this$cooldownProduct = this.getCooldownProduct();
        Map<UUID, ProductLimit> other$cooldownProduct = other.getCooldownProduct();
        if (this$cooldownProduct == null ? other$cooldownProduct != null : !((Object)this$cooldownProduct).equals(other$cooldownProduct)) {
            return false;
        }
        List<ProductTransaction> this$transactions = this.getTransactions();
        List<ProductTransaction> other$transactions = other.getTransactions();
        return !(this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<UUID, ProductLimit> $cooldownProduct = this.getCooldownProduct();
        result = result * 59 + ($cooldownProduct == null ? 43 : ((Object)$cooldownProduct).hashCode());
        List<ProductTransaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserInfo(uuid=" + String.valueOf(this.getUuid()) + ", name=" + this.getName() + ", cooldownProduct=" + String.valueOf(this.getCooldownProduct()) + ", transactions=" + String.valueOf(this.getTransactions()) + ")";
    }
}

