/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.command;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.command.ResGenSuggestions;
import com.iafenvoy.resgen.data.WorldGeneratorState;
import com.iafenvoy.resgen.data.single.BlockTagGeneratorData;
import com.iafenvoy.resgen.data.single.GeneratorDataBase;
import com.iafenvoy.resgen.data.single.ItemLootTableGeneratorData;
import com.iafenvoy.resgen.data.single.ItemTagGeneratorData;
import com.iafenvoy.resgen.data.single.SingleBlockGeneratorData;
import com.iafenvoy.resgen.data.single.SingleItemGeneratorData;
import com.iafenvoy.resgen.util.ParticleUtils;
import com.iafenvoy.server.i18n.ServerI18n;
import com.iafenvoy.server.i18n.ServerI18nExceptionType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class ResGenCommand {
    private static final ServerI18nExceptionType DUPLICATE = new ServerI18nExceptionType("message.resource_generator.duplicated");
    private static final ServerI18nExceptionType NOT_FOUND = new ServerI18nExceptionType("message.resource_generator.not_found");
    private static final ServerI18nExceptionType THIS_IS_NOT_GENERATOR = new ServerI18nExceptionType("message.resource_generator.this_is_not_generator");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resgen").requires(src -> !src.getServer().isDedicatedServer() || src.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.literal((String)"item").then(Commands.argument((String)"stack", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ResGenCommand::addItem))))).then(Commands.literal((String)"itemTag").then(Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests(ResGenSuggestions.ITEM_TAG).executes(ctx -> ResGenCommand.add((CommandContext<CommandSourceStack>)ctx, pos -> new ItemTagGeneratorData((BlockPos)pos, ResourceLocationArgument.getId((CommandContext)ctx, (String)"tag"))))))).then(Commands.literal((String)"lootTable").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests(ResGenSuggestions.LOOT_TABLE).executes(ctx -> ResGenCommand.add((CommandContext<CommandSourceStack>)ctx, pos -> new ItemLootTableGeneratorData((BlockPos)pos, ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"))))))).then(Commands.literal((String)"block").then(Commands.argument((String)"block_state", (ArgumentType)BlockStateArgument.block((CommandBuildContext)access)).executes(ctx1 -> ResGenCommand.add((CommandContext<CommandSourceStack>)ctx1, pos -> new SingleBlockGeneratorData((BlockPos)pos, BlockStateArgument.getBlock((CommandContext)ctx1, (String)"block_state").getState())))))).then(Commands.literal((String)"blockTag").then(Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests(ResGenSuggestions.BLOCK_TAG).executes(ctx -> ResGenCommand.add((CommandContext<CommandSourceStack>)ctx, pos -> new BlockTagGeneratorData((BlockPos)pos, ResourceLocationArgument.getId((CommandContext)ctx, (String)"tag"))))))))).then(Commands.literal((String)"remove").executes(ResGenCommand::remove))).then(Commands.literal((String)"info").executes(ResGenCommand::info))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(Commands.literal((String)"chunk").executes(ctx -> ResGenCommand.list((CommandContext<CommandSourceStack>)ctx, 0.0)))).then(Commands.literal((String)"range").then(Commands.argument((String)"range", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(ctx -> ResGenCommand.list((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"range"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"highlight").then(Commands.literal((String)"chunk").executes(ctx -> ResGenCommand.highlight((CommandContext<CommandSourceStack>)ctx, 0.0)))).then(Commands.literal((String)"range").then(Commands.argument((String)"range", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(ctx -> ResGenCommand.highlight((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"range"))))))));
    }

    private static int addItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        ItemStack stack = ItemArgument.getItem(ctx, (String)"stack").createItemStack(count, false);
        return ResGenCommand.add(ctx, pos -> new SingleItemGeneratorData((BlockPos)pos, stack));
    }

    private static int add(CommandContext<CommandSourceStack> context, Function<BlockPos, GeneratorDataBase> constructor) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.getLevel();
        BlockPos pos = Vec3Argument.getCoordinates(context, (String)"pos").getBlockPos(source);
        GeneratorDataBase data = constructor.apply(pos);
        data.setInterval(IntegerArgumentType.getInteger(context, (String)"interval"));
        if (ResGenCommand.getState(world).add(data)) {
            ParticleUtils.highlight(world, pos);
            source.sendSystemMessage(ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.success", (String[])new String[0]));
            return 1;
        }
        throw DUPLICATE.create(source, new String[0]);
    }

    private static int remove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.getLevel();
        BlockPos pos = Vec3Argument.getCoordinates(context, (String)"pos").getBlockPos(source);
        Optional<GeneratorDataBase> optional = ResGenCommand.getState(world).remove(pos);
        if (optional.isPresent()) {
            source.sendSystemMessage(ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.success", (String[])new String[0]));
            return 1;
        }
        throw NOT_FOUND.create(source, new String[0]);
    }

    private static int info(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.getLevel();
        BlockPos pos = Vec3Argument.getCoordinates(context, (String)"pos").getBlockPos(source);
        Optional<GeneratorDataBase> optional = ResGenCommand.getState(world).get(pos);
        if (optional.isPresent()) {
            ParticleUtils.highlight(world, pos);
            ImmutableList.Builder builder = ImmutableList.builder();
            optional.get().getInfo((ImmutableList.Builder<Component>)builder, source);
            source.sendSystemMessage((Component)builder.build().stream().reduce(Component.empty(), (p, c) -> p.append(c).append("\n"), MutableComponent::append));
            return 1;
        }
        throw THIS_IS_NOT_GENERATOR.create(source, new String[0]);
    }

    private static int list(CommandContext<CommandSourceStack> context, double range) throws CommandSyntaxException {
        List<GeneratorDataBase> data;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.getLevel();
        BlockPos pos = Vec3Argument.getCoordinates(context, (String)"pos").getBlockPos(source);
        WorldGeneratorState state = ResGenCommand.getState(world);
        List<GeneratorDataBase> list = data = range == 0.0 ? state.getInChunk(pos) : state.getInRange(Vec3.atLowerCornerOf((Vec3i)pos), range);
        if (data.isEmpty()) {
            throw NOT_FOUND.create(source, new String[0]);
        }
        source.sendSystemMessage((Component)Component.literal((String)data.stream().map(x -> "[x=%d,y=%d,z=%d] %s".formatted(x.getPos().getX(), x.getPos().getY(), x.getPos().getZ(), x.getType().toString())).collect(Collectors.joining("\n"))));
        return data.size();
    }

    private static int highlight(CommandContext<CommandSourceStack> context, double range) throws CommandSyntaxException {
        List<GeneratorDataBase> data;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.getLevel();
        BlockPos pos = Vec3Argument.getCoordinates(context, (String)"pos").getBlockPos(source);
        WorldGeneratorState state = ResGenCommand.getState(world);
        List<GeneratorDataBase> list = data = range == 0.0 ? state.getInChunk(pos) : state.getInRange(Vec3.atLowerCornerOf((Vec3i)pos), range);
        if (data.isEmpty()) {
            throw NOT_FOUND.create(source, new String[0]);
        }
        data.stream().map(GeneratorDataBase::getPos).forEach(x -> ParticleUtils.highlight(world, x));
        source.sendSystemMessage(ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.success_highlight", (String[])new String[]{String.valueOf(data.size())}));
        return data.size();
    }

    private static WorldGeneratorState getState(ServerLevel world) {
        return WorldGeneratorState.getState(world);
    }
}

