/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data;

import com.iafenvoy.resgen.data.single.GeneratorDataBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class WorldGeneratorState
extends SavedData {
    private static final SavedData.Factory<WorldGeneratorState> TYPE = new SavedData.Factory(WorldGeneratorState::new, WorldGeneratorState::new, DataFixTypes.LEVEL);
    private final List<GeneratorDataBase> data = new LinkedList<GeneratorDataBase>();

    public WorldGeneratorState() {
    }

    public WorldGeneratorState(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.getList("data", 10).stream().map(x -> (CompoundTag)x).map(GeneratorDataBase::decode).forEach(this.data::add);
    }

    public static WorldGeneratorState getState(ServerLevel world) {
        return (WorldGeneratorState)world.getDataStorage().computeIfAbsent(TYPE, "resource_generator");
    }

    public void tick(ServerLevel world) {
        this.data.stream().filter(x -> this.isPosLoaded(world, x.getPos())).forEach(x -> x.tick(world));
    }

    public boolean isPosLoaded(ServerLevel world, BlockPos pos) {
        ChunkPos p = new ChunkPos(pos);
        return world.hasChunk(p.x, p.z);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put("data", (Tag)this.data.stream().map(GeneratorDataBase::encode).collect(ListTag::new, List::add, (a, b) -> {}));
        return nbt;
    }

    public boolean isDirty() {
        return true;
    }

    public Optional<GeneratorDataBase> get(BlockPos pos) {
        return this.data.stream().filter(x -> x.getPos().equals((Object)pos)).findFirst();
    }

    public boolean add(GeneratorDataBase data) {
        if (this.get(data.getPos()).isPresent()) {
            return false;
        }
        this.data.add(data);
        return true;
    }

    public Optional<GeneratorDataBase> remove(BlockPos pos) {
        Optional<GeneratorDataBase> optional = this.get(pos);
        optional.ifPresent(this.data::remove);
        return optional;
    }

    public List<GeneratorDataBase> getInChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return this.data.stream().filter(x -> WorldGeneratorState.isInChunk(chunkPos, x.getPos())).toList();
    }

    public List<GeneratorDataBase> getInRange(Vec3 pos, double range) {
        double rangeSqr = range * range;
        return this.data.stream().filter(x -> pos.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)x.getPos())) <= rangeSqr).toList();
    }

    private static boolean isInChunk(ChunkPos chunkPos, BlockPos blockPos) {
        return chunkPos.getMinBlockX() <= blockPos.getX() || blockPos.getX() <= chunkPos.getMaxBlockX() || chunkPos.getMinBlockZ() <= blockPos.getZ() || blockPos.getZ() <= chunkPos.getMaxBlockZ();
    }
}

