/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.BlockGeneratorDataBase;
import com.iafenvoy.resgen.util.RandomHelper;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockTagGeneratorData
extends BlockGeneratorDataBase {
    private TagKey<Block> blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)""));
    private List<Block> blocks = List.of();

    public BlockTagGeneratorData(BlockPos pos) {
        super(GeneratorType.BLOCK_TAG, pos);
    }

    public BlockTagGeneratorData(BlockPos pos, ResourceLocation tagId) {
        this(pos, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId));
    }

    public BlockTagGeneratorData(BlockPos pos, TagKey<Block> blockTag) {
        super(GeneratorType.BLOCK_TAG, pos);
        this.blockTag = blockTag;
        this.collectBlocks();
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        nbt.putString("blockTag", this.blockTag.location().toString());
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("blockTag")));
        this.collectBlocks();
    }

    private void collectBlocks() {
        this.blocks = BuiltInRegistries.BLOCK.getTag(this.blockTag).map(HolderSet::stream).map(x -> x.map(Holder::value)).map(Stream::toList).orElse(List.of());
    }

    @Override
    protected BlockState getNextBlock() {
        return RandomHelper.randomOne(this.blocks).defaultBlockState();
    }

    @Override
    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        super.getInfo(builder, source);
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info_block_tag", (String[])new String[]{this.blockTag.location().toString()}));
    }
}

