/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.BlockGeneratorDataBase;
import com.iafenvoy.resgen.data.single.ItemGeneratorDataBase;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract sealed class GeneratorDataBase
permits BlockGeneratorDataBase, ItemGeneratorDataBase {
    private final GeneratorType type;
    protected final BlockPos pos;
    private boolean shouldProtect = false;
    private int interval = 0;
    private int currentTick = 0;

    public GeneratorDataBase(GeneratorType type, BlockPos pos) {
        this.type = type;
        this.pos = pos;
    }

    public GeneratorDataBase protect() {
        this.shouldProtect = true;
        return this;
    }

    public void writeToNbt(CompoundTag nbt) {
        nbt.putInt("interval", this.interval);
        nbt.putInt("currentTick", this.currentTick);
    }

    public void readFromNbt(CompoundTag nbt) {
        this.interval = nbt.getInt("interval");
        this.currentTick = nbt.getInt("currentTick");
    }

    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        this.writeToNbt(nbt);
        return nbt;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public abstract void generate(ServerLevel var1);

    public GeneratorType getType() {
        return this.type;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void tick(ServerLevel world) {
        BlockState state = world.getBlockState(this.pos);
        if (!state.is(Blocks.AIR)) {
            if (this.shouldProtect()) {
                world.setBlockAndUpdate(this.pos, Blocks.AIR.defaultBlockState());
            } else {
                return;
            }
        }
        --this.currentTick;
        if (this.currentTick <= 0) {
            this.currentTick = this.interval;
            this.generate(world);
        }
    }

    public boolean shouldProtect() {
        return this.shouldProtect && !this.type.isBlock();
    }

    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info", (String[])new String[]{String.valueOf(this.pos.getX()), String.valueOf(this.pos.getY()), String.valueOf(this.pos.getZ()), String.valueOf(this.shouldProtect()), this.type.toString(), String.valueOf(this.interval)}));
    }

    public static CompoundTag encode(GeneratorDataBase data) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("type", data.type.name());
        nbt.putLong("pos", data.pos.asLong());
        nbt.put("data", (Tag)data.writeToNbt());
        return nbt;
    }

    public static GeneratorDataBase decode(CompoundTag nbt) {
        GeneratorType type = GeneratorType.valueOf(nbt.getString("type"));
        return type.construct(BlockPos.of((long)nbt.getLong("pos")), nbt.getCompound("data"));
    }
}

