/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.ItemGeneratorDataBase;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class ItemLootTableGeneratorData
extends ItemGeneratorDataBase {
    private final Function<ServerLevel, LootParams> paramsFunc = world -> new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.pos)).create(LootContextParamSets.CHEST);
    private ResourceLocation lootTable = ResourceLocation.tryParse((String)"");

    public ItemLootTableGeneratorData(BlockPos pos) {
        super(GeneratorType.ITEM_LOOT_TABLE, pos);
    }

    public ItemLootTableGeneratorData(BlockPos pos, ResourceLocation lootTable) {
        super(GeneratorType.ITEM_LOOT_TABLE, pos);
        this.lootTable = lootTable;
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        nbt.putString("lootTable", this.lootTable.toString());
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.lootTable = ResourceLocation.tryParse((String)nbt.getString("lootTable"));
    }

    @Override
    public List<ItemStack> getNextItems(ServerLevel world) {
        return world.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable)).getRandomItems(this.paramsFunc.apply(world));
    }

    @Override
    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        super.getInfo(builder, source);
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info_item_loot_table", (String[])new String[]{this.lootTable.toString()}));
    }
}

