/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.ItemGeneratorDataBase;
import com.iafenvoy.resgen.util.RandomHelper;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ItemTagGeneratorData
extends ItemGeneratorDataBase {
    private TagKey<Item> itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)""));
    private List<Item> items = List.of();

    public ItemTagGeneratorData(BlockPos pos) {
        super(GeneratorType.ITEM_TAG, pos);
    }

    public ItemTagGeneratorData(BlockPos pos, ResourceLocation tagId) {
        this(pos, (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId));
    }

    public ItemTagGeneratorData(BlockPos pos, TagKey<Item> itemTag) {
        super(GeneratorType.ITEM_TAG, pos);
        this.itemTag = itemTag;
        this.collectItems();
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        nbt.putString("itemTag", this.itemTag.location().toString());
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("itemTag")));
        this.collectItems();
    }

    private void collectItems() {
        this.items = BuiltInRegistries.ITEM.getTag(this.itemTag).map(HolderSet::stream).map(x -> x.map(Holder::value)).map(Stream::toList).orElse(List.of());
    }

    @Override
    public List<ItemStack> getNextItems(ServerLevel world) {
        return List.of(RandomHelper.randomOne(this.items).getDefaultInstance());
    }

    @Override
    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        super.getInfo(builder, source);
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info_item_tag", (String[])new String[]{this.itemTag.location().toString()}));
    }
}

