/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.ResourceGenerator;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.BlockGeneratorDataBase;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public final class SingleBlockGeneratorData
extends BlockGeneratorDataBase {
    private BlockState state = Blocks.AIR.defaultBlockState();

    public SingleBlockGeneratorData(BlockPos pos) {
        super(GeneratorType.SINGLE_BLOCK, pos);
    }

    public SingleBlockGeneratorData(BlockPos pos, BlockState state) {
        super(GeneratorType.SINGLE_BLOCK, pos);
        this.state = state;
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        nbt.put("block", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.state).resultOrPartial(arg_0 -> ((Logger)ResourceGenerator.LOGGER).error(arg_0)).orElse(new CompoundTag()));
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.state = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("block")).resultOrPartial(arg_0 -> ((Logger)ResourceGenerator.LOGGER).error(arg_0)).orElse(Blocks.AIR.defaultBlockState());
    }

    @Override
    protected BlockState getNextBlock() {
        return this.state;
    }

    @Override
    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        super.getInfo(builder, source);
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info_block", (String[])new String[]{this.state.toString()}));
    }
}

