/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.ResourceGenerator;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.ItemGeneratorDataBase;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public final class SingleItemGeneratorData
extends ItemGeneratorDataBase {
    private ItemStack stack = ItemStack.EMPTY;

    public SingleItemGeneratorData(BlockPos pos) {
        super(GeneratorType.SINGLE_ITEM, pos);
    }

    public SingleItemGeneratorData(BlockPos pos, ItemStack stack) {
        super(GeneratorType.SINGLE_ITEM, pos);
        this.stack = stack;
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        nbt.put("item", (Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stack).resultOrPartial(arg_0 -> ((Logger)ResourceGenerator.LOGGER).error(arg_0)).orElse(new CompoundTag()));
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.stack = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("item")).resultOrPartial(arg_0 -> ((Logger)ResourceGenerator.LOGGER).error(arg_0)).orElse(ItemStack.EMPTY);
    }

    @Override
    public List<ItemStack> getNextItems(ServerLevel world) {
        return List.of(this.stack);
    }

    @Override
    public void getInfo(ImmutableList.Builder<Component> builder, CommandSourceStack source) throws CommandSyntaxException {
        super.getInfo(builder, source);
        builder.add((Object)ServerI18n.translateToLiteral((CommandSourceStack)source, (String)"message.resource_generator.info_item", (String[])new String[]{this.stack.toString()}).copy().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(this.stack)))));
    }
}

