/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.command;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.command.ResGenSuggestions;
import com.iafenvoy.resgen.data.WorldGeneratorState;
import com.iafenvoy.resgen.data.single.BlockTagGeneratorData;
import com.iafenvoy.resgen.data.single.GeneratorDataBase;
import com.iafenvoy.resgen.data.single.ItemLootTableGeneratorData;
import com.iafenvoy.resgen.data.single.ItemTagGeneratorData;
import com.iafenvoy.resgen.data.single.SingleBlockGeneratorData;
import com.iafenvoy.resgen.data.single.SingleItemGeneratorData;
import com.iafenvoy.resgen.util.ParticleUtils;
import com.iafenvoy.server.i18n.ServerI18n;
import com.iafenvoy.server.i18n.ServerI18nExceptionType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2257;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public final class ResGenCommand {
    private static final ServerI18nExceptionType DUPLICATE = new ServerI18nExceptionType("message.resource_generator.duplicated");
    private static final ServerI18nExceptionType NOT_FOUND = new ServerI18nExceptionType("message.resource_generator.not_found");
    private static final ServerI18nExceptionType THIS_IS_NOT_GENERATOR = new ServerI18nExceptionType("message.resource_generator.this_is_not_generator");

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resgen").requires(src -> !src.method_9211().method_3816() || src.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"stack", (ArgumentType)class_2287.method_9776((class_7157)access)).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ResGenCommand::addItem))))).then(class_2170.method_9247((String)"itemTag").then(class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).suggests(ResGenSuggestions.ITEM_TAG).executes(ctx -> ResGenCommand.add((CommandContext<class_2168>)ctx, pos -> new ItemTagGeneratorData((class_2338)pos, class_2232.method_9443((CommandContext)ctx, (String)"tag"))))))).then(class_2170.method_9247((String)"lootTable").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(ResGenSuggestions.LOOT_TABLE).executes(ctx -> ResGenCommand.add((CommandContext<class_2168>)ctx, pos -> new ItemLootTableGeneratorData((class_2338)pos, class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(class_2170.method_9247((String)"block").then(class_2170.method_9244((String)"block_state", (ArgumentType)class_2257.method_9653((class_7157)access)).executes(ctx1 -> ResGenCommand.add((CommandContext<class_2168>)ctx1, pos -> new SingleBlockGeneratorData((class_2338)pos, class_2257.method_9655((CommandContext)ctx1, (String)"block_state").method_9494())))))).then(class_2170.method_9247((String)"blockTag").then(class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).suggests(ResGenSuggestions.BLOCK_TAG).executes(ctx -> ResGenCommand.add((CommandContext<class_2168>)ctx, pos -> new BlockTagGeneratorData((class_2338)pos, class_2232.method_9443((CommandContext)ctx, (String)"tag"))))))))).then(class_2170.method_9247((String)"remove").executes(ResGenCommand::remove))).then(class_2170.method_9247((String)"info").executes(ResGenCommand::info))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"chunk").executes(ctx -> ResGenCommand.list((CommandContext<class_2168>)ctx, 0.0)))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"range", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(ctx -> ResGenCommand.list((CommandContext<class_2168>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"range"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"highlight").then(class_2170.method_9247((String)"chunk").executes(ctx -> ResGenCommand.highlight((CommandContext<class_2168>)ctx, 0.0)))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"range", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(ctx -> ResGenCommand.highlight((CommandContext<class_2168>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"range"))))))));
    }

    private static int addItem(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        class_1799 stack = class_2287.method_9777(ctx, (String)"stack").method_9781(count, false);
        return ResGenCommand.add(ctx, pos -> new SingleItemGeneratorData((class_2338)pos, stack));
    }

    private static int add(CommandContext<class_2168> context, Function<class_2338, GeneratorDataBase> constructor) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2338 pos = class_2277.method_9734(context, (String)"pos").method_9704(source);
        GeneratorDataBase data = constructor.apply(pos);
        data.setInterval(IntegerArgumentType.getInteger(context, (String)"interval"));
        if (ResGenCommand.getState(world).add(data)) {
            ParticleUtils.highlight(world, pos);
            source.method_45068(ServerI18n.translateToLiteral((class_2168)source, (String)"message.resource_generator.success", (String[])new String[0]));
            return 1;
        }
        throw DUPLICATE.create(source, new String[0]);
    }

    private static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2338 pos = class_2277.method_9734(context, (String)"pos").method_9704(source);
        Optional<GeneratorDataBase> optional = ResGenCommand.getState(world).remove(pos);
        if (optional.isPresent()) {
            source.method_45068(ServerI18n.translateToLiteral((class_2168)source, (String)"message.resource_generator.success", (String[])new String[0]));
            return 1;
        }
        throw NOT_FOUND.create(source, new String[0]);
    }

    private static int info(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2338 pos = class_2277.method_9734(context, (String)"pos").method_9704(source);
        Optional<GeneratorDataBase> optional = ResGenCommand.getState(world).get(pos);
        if (optional.isPresent()) {
            ParticleUtils.highlight(world, pos);
            ImmutableList.Builder builder = ImmutableList.builder();
            optional.get().getInfo((ImmutableList.Builder<class_2561>)builder, source);
            source.method_45068((class_2561)builder.build().stream().reduce(class_2561.method_43473(), (p, c) -> p.method_10852(c).method_27693("\n"), class_5250::method_10852));
            return 1;
        }
        throw THIS_IS_NOT_GENERATOR.create(source, new String[0]);
    }

    private static int list(CommandContext<class_2168> context, double range) throws CommandSyntaxException {
        List<GeneratorDataBase> data;
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2338 pos = class_2277.method_9734(context, (String)"pos").method_9704(source);
        WorldGeneratorState state = ResGenCommand.getState(world);
        List<GeneratorDataBase> list = data = range == 0.0 ? state.getInChunk(pos) : state.getInRange(class_243.method_24954((class_2382)pos), range);
        if (data.isEmpty()) {
            throw NOT_FOUND.create(source, new String[0]);
        }
        source.method_45068((class_2561)class_2561.method_43470((String)data.stream().map(x -> "[x=%d,y=%d,z=%d] %s".formatted(x.getPos().method_10263(), x.getPos().method_10264(), x.getPos().method_10260(), x.getType().toString())).collect(Collectors.joining("\n"))));
        return data.size();
    }

    private static int highlight(CommandContext<class_2168> context, double range) throws CommandSyntaxException {
        List<GeneratorDataBase> data;
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2338 pos = class_2277.method_9734(context, (String)"pos").method_9704(source);
        WorldGeneratorState state = ResGenCommand.getState(world);
        List<GeneratorDataBase> list = data = range == 0.0 ? state.getInChunk(pos) : state.getInRange(class_243.method_24954((class_2382)pos), range);
        if (data.isEmpty()) {
            throw NOT_FOUND.create(source, new String[0]);
        }
        data.stream().map(GeneratorDataBase::getPos).forEach(x -> ParticleUtils.highlight(world, x));
        source.method_45068(ServerI18n.translateToLiteral((class_2168)source, (String)"message.resource_generator.success_highlight", (String[])new String[]{String.valueOf(data.size())}));
        return data.size();
    }

    private static WorldGeneratorState getState(class_3218 world) {
        return WorldGeneratorState.getState(world);
    }
}

