/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data;

import com.iafenvoy.resgen.data.single.GeneratorDataBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class WorldGeneratorState
extends class_18 {
    private static final class_18.class_8645<WorldGeneratorState> TYPE = new class_18.class_8645(WorldGeneratorState::new, WorldGeneratorState::new, class_4284.field_19212);
    private final List<GeneratorDataBase> data = new LinkedList<GeneratorDataBase>();

    public WorldGeneratorState() {
    }

    public WorldGeneratorState(class_2487 nbt, class_7225.class_7874 registries) {
        nbt.method_10554("data", 10).stream().map(x -> (class_2487)x).map(GeneratorDataBase::decode).forEach(this.data::add);
    }

    public static WorldGeneratorState getState(class_3218 world) {
        return (WorldGeneratorState)world.method_17983().method_17924(TYPE, "resource_generator");
    }

    public void tick(class_3218 world) {
        this.data.stream().filter(x -> this.isPosLoaded(world, x.getPos())).forEach(x -> x.tick(world));
    }

    public boolean isPosLoaded(class_3218 world, class_2338 pos) {
        class_1923 p = new class_1923(pos);
        return world.method_8393(p.field_9181, p.field_9180);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registries) {
        nbt.method_10566("data", (class_2520)this.data.stream().map(GeneratorDataBase::encode).collect(class_2499::new, List::add, (a, b) -> {}));
        return nbt;
    }

    public boolean method_79() {
        return true;
    }

    public Optional<GeneratorDataBase> get(class_2338 pos) {
        return this.data.stream().filter(x -> x.getPos().equals((Object)pos)).findFirst();
    }

    public boolean add(GeneratorDataBase data) {
        if (this.get(data.getPos()).isPresent()) {
            return false;
        }
        this.data.add(data);
        return true;
    }

    public Optional<GeneratorDataBase> remove(class_2338 pos) {
        Optional<GeneratorDataBase> optional = this.get(pos);
        optional.ifPresent(this.data::remove);
        return optional;
    }

    public List<GeneratorDataBase> getInChunk(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        return this.data.stream().filter(x -> WorldGeneratorState.isInChunk(chunkPos, x.getPos())).toList();
    }

    public List<GeneratorDataBase> getInRange(class_243 pos, double range) {
        double rangeSqr = range * range;
        return this.data.stream().filter(x -> pos.method_1025(class_243.method_24954((class_2382)x.getPos())) <= rangeSqr).toList();
    }

    private static boolean isInChunk(class_1923 chunkPos, class_2338 blockPos) {
        return chunkPos.method_8326() <= blockPos.method_10263() || blockPos.method_10263() <= chunkPos.method_8327() || chunkPos.method_8328() <= blockPos.method_10260() || blockPos.method_10260() <= chunkPos.method_8329();
    }
}

