/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.resgen.data.single;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.resgen.data.GeneratorType;
import com.iafenvoy.resgen.data.single.BlockGeneratorDataBase;
import com.iafenvoy.resgen.data.single.ItemGeneratorDataBase;
import com.iafenvoy.server.i18n.ServerI18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public abstract sealed class GeneratorDataBase
permits BlockGeneratorDataBase, ItemGeneratorDataBase {
    private final GeneratorType type;
    protected final class_2338 pos;
    private boolean shouldProtect = false;
    private int interval = 0;
    private int currentTick = 0;

    public GeneratorDataBase(GeneratorType type, class_2338 pos) {
        this.type = type;
        this.pos = pos;
    }

    public GeneratorDataBase protect() {
        this.shouldProtect = true;
        return this;
    }

    public void writeToNbt(class_2487 nbt) {
        nbt.method_10569("interval", this.interval);
        nbt.method_10569("currentTick", this.currentTick);
    }

    public void readFromNbt(class_2487 nbt) {
        this.interval = nbt.method_10550("interval");
        this.currentTick = nbt.method_10550("currentTick");
    }

    public class_2487 writeToNbt() {
        class_2487 nbt = new class_2487();
        this.writeToNbt(nbt);
        return nbt;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public abstract void generate(class_3218 var1);

    public GeneratorType getType() {
        return this.type;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void tick(class_3218 world) {
        class_2680 state = world.method_8320(this.pos);
        if (!state.method_27852(class_2246.field_10124)) {
            if (this.shouldProtect()) {
                world.method_8501(this.pos, class_2246.field_10124.method_9564());
            } else {
                return;
            }
        }
        --this.currentTick;
        if (this.currentTick <= 0) {
            this.currentTick = this.interval;
            this.generate(world);
        }
    }

    public boolean shouldProtect() {
        return this.shouldProtect && !this.type.isBlock();
    }

    public void getInfo(ImmutableList.Builder<class_2561> builder, class_2168 source) throws CommandSyntaxException {
        builder.add((Object)ServerI18n.translateToLiteral((class_2168)source, (String)"message.resource_generator.info", (String[])new String[]{String.valueOf(this.pos.method_10263()), String.valueOf(this.pos.method_10264()), String.valueOf(this.pos.method_10260()), String.valueOf(this.shouldProtect()), this.type.toString(), String.valueOf(this.interval)}));
    }

    public static class_2487 encode(GeneratorDataBase data) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("type", data.type.name());
        nbt.method_10544("pos", data.pos.method_10063());
        nbt.method_10566("data", (class_2520)data.writeToNbt());
        return nbt;
    }

    public static GeneratorDataBase decode(class_2487 nbt) {
        GeneratorType type = GeneratorType.valueOf(nbt.method_10558("type"));
        return type.construct(class_2338.method_10092((long)nbt.method_10537("pos")), nbt.method_10562("data"));
    }
}

