/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.factory.ExtraWarpFactory;
import com.vecoo.extrawarp.config.LocaleConfig;
import com.vecoo.extrawarp.storage.warp.Warp;
import com.vecoo.extrawarp.util.PermissionNodes;
import com.vecoo.extrawarp.util.Utils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class WarpCommand {
    private static final Set<String> COMMAND_ARGUMENT = Sets.newHashSet((Object[])new String[]{"set", "pset", "delete", "private", "invite", "uninvite", "blacklist", "public", "rename", "welcome", "help", "reload", "assets", "info", "update"});

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_COMMAND))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.execute(StringArgumentType.getString((CommandContext)e, (String)"name"), ((class_2168)e.getSource()).method_9207())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_SET_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((class_2168)e.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pset").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.PRIVATE_WARP_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executePrivateSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((class_2168)e.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_DELETE_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeDelete(StringArgumentType.getString((CommandContext)e, (String)"warp"), (class_2168)e.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"private").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_PRIVATE_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePrivate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((class_2168)e.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"invite").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_INVITE_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String nick : ((class_2168)s.getSource()).method_9262()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((class_2168)e.getSource()).method_9207())))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"uninvite").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_UNINVITE_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                for (UUID uuid : warp.getInvitePlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)uuid);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUnInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((class_2168)e.getSource()).method_9207())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_BLACKLIST_COMMAND))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String nick : ((class_2168)s.getSource()).method_9262()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeAddBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((class_2168)e.getSource()).method_9207())))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                for (UUID uuid : warp.getBlacklistPlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)uuid);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((class_2168)e.getSource()).method_9207()))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"public").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_PUBLIC_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePublic(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((class_2168)e.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rename").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_RENAME_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeRename(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"name"), (class_2168)e.getSource())))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"welcome").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_WELCOME_COMMAND))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), (class_2168)e.getSource()))).then(class_2170.method_9244((String)"message", (ArgumentType)class_2196.method_9340()).executes(e -> WarpCommand.executeSetWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), class_2196.method_9339((CommandContext)e, (String)"message"), (class_2168)e.getSource())))))).then(class_2170.method_9247((String)"help").executes(e -> WarpCommand.executeHelp((class_2168)e.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_RELOAD_COMMAND))).executes(e -> WarpCommand.executeReload((class_2168)e.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"assets").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_ASSETS_COMMAND))).executes(e -> WarpCommand.executeAssets(((class_2168)e.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_ASSETS_PLAYER_COMMAND))).suggests((s, builder) -> {
            for (String nick : ((class_2168)s.getSource()).method_9262()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeAssetsPlayer((class_2168)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"top").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_TOP_COMMAND))).executes(e -> WarpCommand.executeTop((class_2168)e.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_INFO_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeInfo(StringArgumentType.getString((CommandContext)e, (String)"warp"), (class_2168)e.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)PermissionNodes.WARP_UPDATE_COMMAND))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((class_2168)s.getSource()).method_9207().method_5667())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUpdate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((class_2168)e.getSource()).method_9207())))));
    }

    private static int execute(@NotNull String name, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID playerUUID = player.method_5667();
        if (!warp.getOwnerUUID().equals(playerUUID) && warp.isLocked() && !warp.getInvitePlayers().contains(playerUUID) && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPrivate().replace("%warp%", name)));
            return 0;
        }
        if (warp.getBlacklistPlayers().contains(playerUUID) && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getBlacklistWarp().replace("%warp%", name)));
            return 0;
        }
        class_3218 level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getX() >= level.method_8621().method_11963() || warp.getY() < (double)level.method_31607() || warp.getY() > (double)level.method_31600() || warp.getZ() >= level.method_8621().method_11977()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.teleportWarp(player, warp)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.addUniquePlayer(playerUUID);
        if (warp.getWelcomeText().isEmpty()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getTeleportWarp().replace("%warp%", warp.getName())));
        } else {
            player.method_43496(UtilChat.formatMessage((String)(localeConfig.getAddWelcome() + warp.getWelcomeText())));
        }
        return 1;
    }

    private static int executeSet(@NotNull String name, @NotNull class_3222 player) {
        int maxWarpsPlayer = Utils.maxCountWarp(player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.method_5667()).size() >= maxWarpsPlayer && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarpsPlayer))));
            return 0;
        }
        if (COMMAND_ARGUMENT.contains(name)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()));
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, false))) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        player.method_43496((class_2561)UtilChat.formatMessage((String)localeConfig.getSetWarp().replace("%warp%", name)).method_27661().method_10852((class_2561)UtilChat.clickableMessageCommand((String)localeConfig.getSetWarpAdditional(), (String)("/warp private " + name)).method_27661().method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverSetToPrivateWarp() + name)))))));
        return 1;
    }

    private static int executePrivateSet(@NotNull String name, @NotNull class_3222 player) {
        int maxWarpsPlayer = Utils.maxCountWarp(player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.method_5667()).size() >= maxWarpsPlayer && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarpsPlayer))));
            return 0;
        }
        if (COMMAND_ARGUMENT.contains(name)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()));
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, true))) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getSetWarpPrivate().replace("%warp%", name)));
        return 1;
    }

    private static int executeDelete(@NotNull String name, @NotNull class_2168 source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (source.method_9228() != null && !warp.getOwnerUUID().equals(source.method_9228().method_5667()) && !UtilPermission.hasPermission((class_2168)source, (String)PermissionNodes.WARP_BYPASS) && source.method_9228() != null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.removeWarp(warp)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpRemoved().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeInfo(@NotNull String name, @NotNull class_2168 source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        HashSet<String> playerInviteName = new HashSet<String>();
        HashSet<String> playerBlacklistName = new HashSet<String>();
        class_3312 gameProfileCache = ExtraWarp.getInstance().getServer().method_3793();
        for (UUID playerUUID : warp.getInvitePlayers()) {
            if (!gameProfileCache.method_14512(playerUUID).isPresent()) continue;
            playerInviteName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        for (UUID playerUUID : warp.getBlacklistPlayers()) {
            if (!gameProfileCache.method_14512(playerUUID).isPresent()) continue;
            playerBlacklistName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        class_3222 player = source.method_44023();
        boolean hideXYZ = player != null && warp.isLocked() && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS) && !warp.getOwnerUUID().equals(player.method_5667()) && !warp.getInvitePlayers().contains(player.method_5667());
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getInfoWarp().replace("%warp%", warp.getName()).replace("%owner%", UtilPlayer.getPlayerName((UUID)warp.getOwnerUUID())).replace("%x%", hideXYZ ? "-" : String.valueOf(warp.getX())).replace("%y%", hideXYZ ? "-" : String.valueOf(warp.getY())).replace("%z%", hideXYZ ? "-" : String.valueOf(warp.getZ())).replace("%dimension%", warp.getDimensionName()).replace("%invitePlayers%", ((Object)playerInviteName).toString()).replace("%blacklistPlayers%", ((Object)playerBlacklistName).toString()).replace("%count%", String.valueOf(warp.getUniquePlayers().size())).replace("%locked%", warp.isLocked() ? localeConfig.getLocked() : localeConfig.getUnlocked())));
        return 1;
    }

    private static int executeUpdate(@NotNull String name, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667()) && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        class_3218 level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getX() >= level.method_8621().method_11963() || warp.getY() < (double)level.method_31607() || warp.getY() > (double)level.method_31600() || warp.getZ() >= level.method_8621().method_11977()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)));
            return 0;
        }
        warp.updatePosition(player);
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpUpdate().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeRename(@NotNull String name, @NotNull String newName, @NotNull class_2168 source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (source.method_9228() != null && !warp.getOwnerUUID().equals(source.method_9228().method_5667()) && !UtilPermission.hasPermission((class_2168)source, (String)PermissionNodes.WARP_BYPASS)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getName().equals(newName)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getEqualsRename().replace("%warp%", warp.getName())));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(newName)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", newName)));
            return 0;
        }
        warp.setName(newName);
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpRename().replace("%warp%", warp.getName()).replace("%name%", newName)));
        return 1;
    }

    private static int executePrivate(@NotNull String name, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (warp.isLocked()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPrivated().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667()) && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setLocked(true);
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getPrivateWarp().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executePublic(@NotNull String name, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!warp.isLocked()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPubliced().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667()) && !UtilPermission.hasPermission((class_3222)player, (String)PermissionNodes.WARP_BYPASS)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setLocked(false);
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getPublicWarp().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeInvite(@NotNull String name, @NotNull String playerName, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        UUID playerUUID = player.method_5667();
        if (!warp.getOwnerUUID().equals(playerUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (playerUUID.equals(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.addInvitePlayer(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        UtilPlayer.sendMessageUuid((UUID)targetUUID, (class_2561)UtilChat.formatMessage((String)localeConfig.getInvitedWarp().replace("%warp%", warp.getName()).replace("%player%", player.method_5477().getString())));
        return 1;
    }

    private static int executeUnInvite(@NotNull String name, @NotNull String playerName, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667())) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.method_5667().equals(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.removeInvitePlayer(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getUnInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeAddBlacklist(@NotNull String name, @NotNull String playerName, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667())) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.method_5667().equals(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.addBlacklistPlayer(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getBlacklistAddedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeRemoveBlacklist(@NotNull String name, @NotNull String playerName, @NotNull class_3222 player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.method_5667())) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.method_5667().equals(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.removeBlacklistPlayer(targetUUID)) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.method_43496(UtilChat.formatMessage((String)localeConfig.getBlacklistRemovedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeAssets(@NotNull class_3222 player) {
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.method_5667());
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        player.method_43496(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getWarpAssets().replace("%count%", String.valueOf(warps.size())).replace("%maxCount%", String.valueOf(Utils.maxCountWarp(player))).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)));
        return 1;
    }

    private static int executeAssetsPlayer(@NotNull class_2168 source, @NotNull String playerName) {
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (targetUUID == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(targetUUID);
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpAssetsPlayer().replace("%player%", playerName).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)));
        return 1;
    }

    private static int executeTop(@NotNull class_2168 source) {
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        List<Warp> topWarps = ExtraWarpFactory.WarpProvider.getWarps().stream().filter(warp -> !warp.isLocked()).sorted(Comparator.comparingInt(warp -> warp.getUniquePlayers().size()).reversed()).limit(10L).toList();
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getTopWarpTitle()));
        for (int i = 0; i < topWarps.size(); ++i) {
            Warp warp2 = topWarps.get(i);
            source.method_45068((class_2561)UtilChat.clickableMessageCommand((String)localeConfig.getTopWarp().replace("%place%", localeConfig.getPlaces().get(i)).replace("%warp%", warp2.getName()).replace("%player%", UtilPlayer.getPlayerName((UUID)warp2.getOwnerUUID())), (String)("/warp " + warp2.getName())).method_27661().method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverTopWarp() + warp2.getName()))))));
        }
        return 1;
    }

    private static int executeSetWelcome(@NotNull String name, class_2561 component, @NotNull class_2168 source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (source.method_9228() != null && !warp.getOwnerUUID().equals(source.method_9228().method_5667()) && !UtilPermission.hasPermission((class_2168)source, (String)PermissionNodes.WARP_BYPASS)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setWelcomeText(component.getString());
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpSetWelcome().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeRemoveWelcome(@NotNull String name, @NotNull class_2168 source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (source.method_9228() != null && !warp.getOwnerUUID().equals(source.method_9228().method_5667()) && !UtilPermission.hasPermission((class_2168)source, (String)PermissionNodes.WARP_BYPASS)) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getWelcomeText().isEmpty()) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpWelcomeEmpty().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setWelcomeText(null);
        source.method_45068(UtilChat.formatMessage((String)localeConfig.getWarpRemoveWelcome().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeHelp(@NotNull class_2168 source) {
        source.method_45068(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getHelp()));
        return 1;
    }

    private static int executeReload(@NotNull class_2168 source) {
        ExtraWarp.getInstance().loadConfig();
        ExtraWarp.getInstance().loadStorage();
        source.method_45068(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getReload()));
        return 1;
    }
}

