/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.storage.warp;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.storage.warp.Warp;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WarpProvider {
    private final transient String filePath;
    private final Set<Warp> warps;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public WarpProvider(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.warps = new HashSet<Warp>();
    }

    @NotNull
    public Set<Warp> getStorage() {
        return this.warps;
    }

    public void updateStorage() {
        this.dirty = true;
    }

    public boolean addWarp(@NotNull Warp warp) {
        if (!this.warps.add(warp)) {
            ExtraWarp.getLogger().error("An error occurred while creating the warp: " + warp.getName());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public boolean removeWarp(@NotNull Warp warp) {
        if (!this.warps.remove(warp)) {
            ExtraWarp.getLogger().error("An error occurred while remove the warp: " + warp.getName());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"WarpStorage.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(3000L).infinite().consume(task -> {
                if (ExtraWarp.getInstance().getServer().method_3806() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"WarpStorage.json", (String)UtilGson.newGson().toJson((Object)this)).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        UtilGson.readFileAsync((String)this.filePath, (String)"WarpStorage.json", el -> this.warps.addAll(((WarpProvider)UtilGson.newGson().fromJson(el, WarpProvider.class)).getStorage())).join();
        this.writeInterval();
    }
}

