/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.api.factory;

import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.storage.warp.Warp;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraWarpFactory {
    public static boolean teleportWarp(@NotNull class_3222 player, @NotNull Warp warp) {
        class_3218 level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            return false;
        }
        class_2338.class_2339 blockPos = new class_2338.class_2339(warp.getX(), warp.getY(), warp.getZ());
        if (!player.method_31549().field_7479 && (blockPos = ExtraWarpFactory.findPosition(blockPos, level)) == null) {
            return false;
        }
        player.method_14251(level, warp.getX(), (double)blockPos.method_10264(), warp.getZ(), warp.getYRot(), warp.getXRot());
        player.method_18799(class_243.field_1353);
        return true;
    }

    @Nullable
    private static class_2338.class_2339 findPosition(@NotNull class_2338.class_2339 blockPos, @NotNull class_3218 level) {
        class_2791 chunk = level.method_14178().method_12121(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4, class_2806.field_12795, true);
        if (chunk == null) {
            return null;
        }
        while (blockPos.method_10264() > level.method_31607() && chunk.method_8320((class_2338)blockPos).method_26215()) {
            blockPos.method_10098(class_2350.field_11033);
        }
        if (blockPos.method_10264() < level.method_31607()) {
            return null;
        }
        if (!chunk.method_8320((class_2338)blockPos).method_26220((class_1922)chunk, (class_2338)blockPos).method_1110()) {
            blockPos.method_10098(class_2350.field_11036);
        }
        return blockPos;
    }

    public static class WarpProvider {
        @NotNull
        public static Set<Warp> getWarps() {
            return ExtraWarp.getInstance().getWarpProvider().getStorage();
        }

        public static boolean hasWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static Warp getWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return warp;
            }
            return null;
        }

        @NotNull
        public static Set<Warp> getWarpsByPlayer(@NotNull UUID playerUUID) {
            HashSet<Warp> warps = new HashSet<Warp>();
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getOwnerUUID().equals(playerUUID)) continue;
                warps.add(warp);
            }
            return warps;
        }

        public static boolean addWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().addWarp(warp);
        }

        public static boolean removeWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().removeWarp(warp);
        }
    }
}

