/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp;

import com.mojang.brigadier.CommandDispatcher;
import com.vecoo.extrawarp.command.WarpCommand;
import com.vecoo.extrawarp.config.LocaleConfig;
import com.vecoo.extrawarp.config.ServerConfig;
import com.vecoo.extrawarp.storage.warp.WarpProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extrawarp")
public class ExtraWarp {
    public static final String MOD_ID = "extrawarp";
    private static final Logger LOGGER = LogManager.getLogger();
    private static ExtraWarp instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private WarpProvider warpProvider;
    private MinecraftServer server;

    public ExtraWarp() {
        instance = this;
        this.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        WarpCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        this.server = event.getServer();
        this.loadStorage();
        PermissionAPI.registerNode((String)"minecraft.command.warp", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.set", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.pset", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.delete", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.private", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.invite", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.uninvite", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.blacklist", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.public", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.rename", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.welcome", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.reload", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.assets", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.assets.player", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.top", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.info", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.warp.update", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"extrawarp.bypass", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        for (String node : this.config.getPermissionListingList()) {
            PermissionAPI.registerNode((String)node, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        }
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.warpProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.warpProvider == null) {
                this.warpProvider = new WarpProvider("/%directory%/storage/ExtraWarp/", this.server);
            }
            this.warpProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    public static ExtraWarp getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraWarp.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraWarp.instance.locale;
    }

    public WarpProvider getWarpProvider() {
        return ExtraWarp.instance.warpProvider;
    }

    public MinecraftServer getServer() {
        return ExtraWarp.instance.server;
    }
}

