/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.api.factory;

import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.events.WarpEvent;
import com.vecoo.extrawarp.storage.warp.Warp;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ExtraWarpFactory {
    public static boolean teleportWarp(@Nonnull ServerPlayerEntity player, @Nonnull Warp warp) {
        ServerWorld world = UtilWorld.getWorldByName((String)warp.getDimensionName());
        if (world == null) {
            return false;
        }
        BlockPos.Mutable blockPos = new BlockPos.Mutable(warp.getX(), warp.getY(), warp.getZ());
        if (!player.field_71075_bZ.field_75100_b && (blockPos = ExtraWarpFactory.findPosition(blockPos, world)) == null) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new WarpEvent.Teleport(warp, player))) {
            return false;
        }
        player.func_200619_a(world, warp.getX(), (double)blockPos.func_177956_o(), warp.getZ(), warp.getYRot(), warp.getXRot());
        player.func_213317_d(Vector3d.field_186680_a);
        return true;
    }

    @Nullable
    private static BlockPos.Mutable findPosition(@Nonnull BlockPos.Mutable blockPos, @Nonnull ServerWorld world) {
        IChunk chunk = world.func_72863_F().func_212849_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, ChunkStatus.field_222613_i, true);
        if (chunk == null) {
            return null;
        }
        while (blockPos.func_177956_o() > 1 && chunk.func_180495_p((BlockPos)blockPos).func_203425_a(Blocks.field_150350_a)) {
            blockPos.func_189536_c(Direction.DOWN);
        }
        if (blockPos.func_177956_o() <= 1) {
            return null;
        }
        if (!chunk.func_180495_p((BlockPos)blockPos).func_196952_d((IBlockReader)chunk, (BlockPos)blockPos).func_197766_b()) {
            blockPos.func_189536_c(Direction.UP);
        }
        return blockPos;
    }

    public static class WarpProvider {
        @Nonnull
        public static Set<Warp> getWarps() {
            return ExtraWarp.getInstance().getWarpProvider().getStorage();
        }

        public static boolean hasWarpByName(@Nonnull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static Warp getWarpByName(@Nonnull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return warp;
            }
            return null;
        }

        @Nonnull
        public static Set<Warp> getWarpsByPlayer(@Nonnull UUID playerUUID) {
            HashSet<Warp> warps = new HashSet<Warp>();
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getOwnerUUID().equals(playerUUID)) continue;
                warps.add(warp);
            }
            return warps;
        }

        public static boolean addWarp(@Nonnull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().addWarp(warp);
        }

        public static boolean removeWarp(@Nonnull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().removeWarp(warp);
        }
    }
}

