/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.factory.ExtraWarpFactory;
import com.vecoo.extrawarp.config.LocaleConfig;
import com.vecoo.extrawarp.storage.warp.Warp;
import com.vecoo.extrawarp.util.Utils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.UsernameCache;

public class WarpCommand {
    private static final Set<String> COMMAND_ARGUMENT = Sets.newHashSet((Object[])new String[]{"set", "pset", "delete", "private", "invite", "uninvite", "blacklist", "public", "rename", "welcome", "help", "reload", "assets", "info", "update"});

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"warp").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp"))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.execute(StringArgumentType.getString((CommandContext)e, (String)"name"), ((CommandSource)e.getSource()).func_197035_h())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.set"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSource)e.getSource()).func_197035_h()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"pset").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.pset"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executePrivateSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSource)e.getSource()).func_197035_h()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"delete").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.delete"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeDelete(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSource)e.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"private").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.private"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePrivate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSource)e.getSource()).func_197035_h()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"invite").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.invite"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String nick : ((CommandSource)s.getSource()).func_197011_j()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSource)e.getSource()).func_197035_h())))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"uninvite").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.uninvite"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                for (UUID uuid : warp.getInvitePlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)uuid);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUnInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSource)e.getSource()).func_197035_h())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"blacklist").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.blacklist"))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String nick : ((CommandSource)s.getSource()).func_197011_j()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeAddBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSource)e.getSource()).func_197035_h())))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                for (UUID uuid : warp.getBlacklistPlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)uuid);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSource)e.getSource()).func_197035_h()))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"public").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.public"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePublic(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSource)e.getSource()).func_197035_h()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"rename").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.rename"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeRename(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"name"), (CommandSource)e.getSource())))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"welcome").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.welcome"))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSource)e.getSource()))).then(Commands.func_197056_a((String)"message", (ArgumentType)MessageArgument.func_197123_a()).executes(e -> WarpCommand.executeSetWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), MessageArgument.func_197124_a((CommandContext)e, (String)"message"), (CommandSource)e.getSource())))))).then(Commands.func_197057_a((String)"help").executes(e -> WarpCommand.executeHelp((CommandSource)e.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.reload"))).executes(e -> WarpCommand.executeReload((CommandSource)e.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"assets").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.assets"))).executes(e -> WarpCommand.executeAssets(((CommandSource)e.getSource()).func_197035_h()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.assets.player"))).suggests((s, builder) -> {
            for (String nick : ((CommandSource)s.getSource()).func_197011_j()) {
                if (!nick.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(nick);
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeAssetsPlayer((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"top").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.top"))).executes(e -> WarpCommand.executeTop((CommandSource)e.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.info"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeInfo(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSource)e.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"update").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.warp.update"))).then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUpdate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSource)e.getSource()).func_197035_h())))));
    }

    private static int execute(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        UUID playerUUID = player.func_110124_au();
        if (!warp.getOwnerUUID().equals(playerUUID) && warp.isLocked() && !warp.getInvitePlayers().contains(playerUUID) && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPrivate().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (warp.getBlacklistPlayers().contains(playerUUID) && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getBlacklistWarp().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        ServerWorld world = UtilWorld.getWorldByName((String)warp.getDimensionName());
        if (world == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (warp.getX() >= world.func_175723_af().func_177728_d() || warp.getY() < 1.0 || warp.getY() > (double)world.func_217301_I() || warp.getZ() >= world.func_175723_af().func_177733_e()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (!ExtraWarpFactory.teleportWarp(player, warp)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.getUniquePlayers().contains(playerUUID)) {
            warp.addUniquePlayer(playerUUID);
        }
        if (warp.getWelcomeText().isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTeleportWarp().replace("%warp%", warp.getName())), Util.field_240973_b_);
        } else {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)(localeConfig.getAddWelcome() + warp.getWelcomeText())), Util.field_240973_b_);
        }
        return 1;
    }

    private static int executeSet(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        int maxWarpsPlayer = Utils.maxCountWarp((PlayerEntity)player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.func_110124_au()).size() >= maxWarpsPlayer && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarpsPlayer))), Util.field_240973_b_);
            return 0;
        }
        if (COMMAND_ARGUMENT.contains(name)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()), Util.field_240973_b_);
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()), Util.field_240973_b_);
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, false))) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getSetWarp().replace("%warp%", name)).func_230529_a_((ITextComponent)UtilChat.clickableMessageCommand((String)localeConfig.getSetWarpAdditional(), (String)("/warp private " + name)).func_240703_c_(Style.field_240709_b_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverSetToPrivateWarp() + name)))))), Util.field_240973_b_);
        return 1;
    }

    private static int executePrivateSet(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        int maxWarpsPlayer = Utils.maxCountWarp((PlayerEntity)player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.func_110124_au()).size() >= maxWarpsPlayer && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarpsPlayer))), Util.field_240973_b_);
            return 0;
        }
        if (COMMAND_ARGUMENT.contains(name)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()), Util.field_240973_b_);
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()), Util.field_240973_b_);
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, true))) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getSetWarpPrivate().replace("%warp%", name)), Util.field_240973_b_);
        return 1;
    }

    private static int executeDelete(@Nonnull String name, @Nonnull CommandSource source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), false);
            return 0;
        }
        if (source.func_197022_f() != null && !warp.getOwnerUUID().equals(source.func_197022_f().func_110124_au()) && !UtilPermission.hasPermission((CommandSource)source, (String)"extrawarp.bypass") && source.func_197022_f() != null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), false);
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.removeWarp(warp)) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)), false);
            return 0;
        }
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpRemoved().replace("%warp%", warp.getName())), false);
        return 1;
    }

    private static int executeInfo(@Nonnull String name, @Nonnull CommandSource source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), false);
            return 0;
        }
        HashSet<String> playerInviteName = new HashSet<String>();
        HashSet<String> playerBlacklistName = new HashSet<String>();
        for (UUID playerUUID : warp.getInvitePlayers()) {
            if (!UsernameCache.containsUUID((UUID)playerUUID)) continue;
            playerInviteName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        for (UUID playerUUID : warp.getBlacklistPlayers()) {
            if (!UsernameCache.containsUUID((UUID)playerUUID)) continue;
            playerBlacklistName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        ServerPlayerEntity player = (ServerPlayerEntity)source.func_197022_f();
        boolean hideXYZ = player != null && warp.isLocked() && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass") && !warp.getOwnerUUID().equals(player.func_110124_au()) && !warp.getInvitePlayers().contains(player.func_110124_au());
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getInfoWarp().replace("%warp%", warp.getName()).replace("%owner%", UtilPlayer.getPlayerName((UUID)warp.getOwnerUUID())).replace("%x%", hideXYZ ? "-" : String.valueOf(warp.getX())).replace("%y%", hideXYZ ? "-" : String.valueOf(warp.getY())).replace("%z%", hideXYZ ? "-" : String.valueOf(warp.getZ())).replace("%dimension%", warp.getDimensionName()).replace("%invitePlayers%", ((Object)playerInviteName).toString()).replace("%blacklistPlayers%", ((Object)playerBlacklistName).toString()).replace("%count%", String.valueOf(warp.getUniquePlayers().size())).replace("%locked%", warp.isLocked() ? localeConfig.getLocked() : localeConfig.getUnlocked())), false);
        return 1;
    }

    private static int executeUpdate(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.func_110124_au()) && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        ServerWorld world = UtilWorld.getWorldByName((String)warp.getDimensionName());
        if (world == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (warp.getX() >= world.func_175723_af().func_177728_d() || warp.getY() < 1.0 || warp.getY() > (double)world.func_217301_I() || warp.getZ() >= world.func_175723_af().func_177733_e()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        warp.updatePosition(player);
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpUpdate().replace("%warp%", warp.getName())), Util.field_240973_b_);
        return 1;
    }

    private static int executeRename(@Nonnull String name, @Nonnull String newName, @Nonnull CommandSource source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), false);
            return 0;
        }
        if (source.func_197022_f() != null && !warp.getOwnerUUID().equals(source.func_197022_f().func_110124_au()) && !UtilPermission.hasPermission((CommandSource)source, (String)"extrawarp.bypass")) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), false);
            return 0;
        }
        if (warp.getName().equals(newName)) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEqualsRename().replace("%warp%", warp.getName())), false);
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(newName)) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", newName)), false);
            return 0;
        }
        warp.setName(newName);
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpRename().replace("%warp%", warp.getName()).replace("%name%", newName)), false);
        return 1;
    }

    private static int executePrivate(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (warp.isLocked()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPrivated().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.func_110124_au()) && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        warp.setLocked(true);
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPrivateWarp().replace("%warp%", warp.getName())), Util.field_240973_b_);
        return 1;
    }

    private static int executePublic(@Nonnull String name, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        if (!warp.isLocked()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPubliced().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.func_110124_au()) && !UtilPermission.hasPermission((PlayerEntity)player, (String)"extrawarp.bypass")) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        warp.setLocked(false);
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPublicWarp().replace("%warp%", warp.getName())), Util.field_240973_b_);
        return 1;
    }

    private static int executeInvite(@Nonnull String name, @Nonnull String playerName, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        UUID playerUUID = player.func_110124_au();
        if (!warp.getOwnerUUID().equals(playerUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (playerUUID.equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.addInvitePlayer(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
        UtilPlayer.sendMessageUuid((UUID)targetUUID, (StringTextComponent)UtilChat.formatMessage((String)localeConfig.getInvitedWarp().replace("%warp%", warp.getName()).replace("%player%", player.func_200200_C_().getString())));
        return 1;
    }

    private static int executeUnInvite(@Nonnull String name, @Nonnull String playerName, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        UUID playerUUID = player.func_110124_au();
        if (!warp.getOwnerUUID().equals(playerUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (player.func_110124_au().equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.removeInvitePlayer(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getUnInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
        return 1;
    }

    private static int executeAddBlacklist(@Nonnull String name, @Nonnull String playerName, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        UUID playerUUID = player.func_110124_au();
        if (!warp.getOwnerUUID().equals(playerUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (playerUUID.equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.addBlacklistPlayer(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getBlacklistAddedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
        return 1;
    }

    private static int executeRemoveBlacklist(@Nonnull String name, @Nonnull String playerName, @Nonnull ServerPlayerEntity player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        UUID playerUUID = player.func_110124_au();
        if (!warp.getOwnerUUID().equals(playerUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (playerUUID.equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())), Util.field_240973_b_);
            return 0;
        }
        if (!warp.removeBlacklistPlayer(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getBlacklistRemovedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)), Util.field_240973_b_);
        return 1;
    }

    private static int executeAssets(@Nonnull ServerPlayerEntity player) {
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.func_110124_au());
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getWarpAssets().replace("%count%", String.valueOf(warps.size())).replace("%maxCount%", String.valueOf(Utils.maxCountWarp((PlayerEntity)player))).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)), Util.field_240973_b_);
        return 1;
    }

    private static int executeAssetsPlayer(@Nonnull CommandSource source, @Nonnull String playerName) {
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (targetUUID == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)), false);
            return 0;
        }
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(targetUUID);
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpAssetsPlayer().replace("%player%", playerName).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)), false);
        return 1;
    }

    private static int executeTop(@Nonnull CommandSource source) {
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        List topWarps = ExtraWarpFactory.WarpProvider.getWarps().stream().filter(warp -> !warp.isLocked()).sorted(Comparator.comparingInt(warp -> warp.getUniquePlayers().size()).reversed()).limit(10L).collect(Collectors.toList());
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTopWarpTitle()), false);
        for (int i = 0; i < topWarps.size(); ++i) {
            Warp warp2 = (Warp)topWarps.get(i);
            source.func_197030_a((ITextComponent)UtilChat.clickableMessageCommand((String)localeConfig.getTopWarp().replace("%place%", localeConfig.getPlaces().get(i)).replace("%warp%", warp2.getName()).replace("%player%", UtilPlayer.getPlayerName((UUID)warp2.getOwnerUUID())), (String)("/warp " + warp2.getName())).func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverTopWarp() + warp2.getName()))))), false);
        }
        return 1;
    }

    private static int executeSetWelcome(@Nonnull String name, @Nonnull ITextComponent component, @Nonnull CommandSource source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), false);
            return 0;
        }
        if (source.func_197022_f() != null && !warp.getOwnerUUID().equals(source.func_197022_f().func_110124_au()) && !UtilPermission.hasPermission((CommandSource)source, (String)"extrawarp.bypass")) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), false);
            return 0;
        }
        warp.setWelcomeText(component.getString());
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpSetWelcome().replace("%warp%", warp.getName())), false);
        return 1;
    }

    private static int executeRemoveWelcome(@Nonnull String name, @Nonnull CommandSource source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)), false);
            return 0;
        }
        if (source.func_197022_f() != null && !warp.getOwnerUUID().equals(source.func_197022_f().func_110124_au()) && !UtilPermission.hasPermission((CommandSource)source, (String)"extrawarp.bypass")) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())), false);
            return 0;
        }
        if (warp.getWelcomeText().isEmpty()) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpWelcomeEmpty().replace("%warp%", warp.getName())), false);
            return 0;
        }
        warp.setWelcomeText(null);
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getWarpRemoveWelcome().replace("%warp%", warp.getName())), false);
        return 1;
    }

    private static int executeHelp(@Nonnull CommandSource source) {
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getHelp()), false);
        return 1;
    }

    private static int executeReload(@Nonnull CommandSource source) {
        ExtraWarp.getInstance().loadConfig();
        ExtraWarp.getInstance().loadStorage();
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getReload()), false);
        return 1;
    }
}

