/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.storage.warp;

import com.vecoo.extrawarp.ExtraWarp;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;

public class Warp {
    private String name;
    private double x;
    private double y;
    private double z;
    private float xRot;
    private float yRot;
    private String dimensionName;
    private final UUID ownerUUID;
    private final Set<UUID> invitePlayers;
    private final Set<UUID> blacklistPlayers;
    private final Set<UUID> uniquePlayers;
    private String welcomeText;
    private boolean locked;

    public Warp(@Nonnull String name, @Nonnull ServerPlayerEntity player, boolean isLocked) {
        this.name = name;
        this.x = this.getFormatted(player.func_226277_ct_());
        this.y = this.getFormatted(player.func_226278_cu_());
        this.z = this.getFormatted(player.func_226281_cx_());
        this.xRot = this.getFormatted(player.field_70125_A);
        this.yRot = this.getFormatted(player.field_70177_z);
        this.dimensionName = player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a();
        this.ownerUUID = player.func_110124_au();
        this.invitePlayers = new HashSet<UUID>();
        this.blacklistPlayers = new HashSet<UUID>();
        this.uniquePlayers = new HashSet<UUID>();
        this.welcomeText = "";
        this.locked = isLocked;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    @Nonnull
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Nonnull
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nonnull
    public Set<UUID> getInvitePlayers() {
        return this.invitePlayers;
    }

    @Nonnull
    public Set<UUID> getBlacklistPlayers() {
        return this.blacklistPlayers;
    }

    @Nonnull
    public Set<UUID> getUniquePlayers() {
        return this.uniquePlayers;
    }

    @Nonnull
    public String getWelcomeText() {
        return this.welcomeText;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    public void setCoordinatePosition(double x, double y, double z, float xRot, float yRot) {
        this.x = this.getFormatted(x);
        this.y = this.getFormatted(y);
        this.z = this.getFormatted(z);
        this.xRot = this.getFormatted(xRot);
        this.yRot = this.getFormatted(yRot);
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    public void updatePosition(@Nonnull ServerPlayerEntity player) {
        this.x = this.getFormatted(player.func_226277_ct_());
        this.y = this.getFormatted(player.func_226278_cu_());
        this.z = this.getFormatted(player.func_226281_cx_());
        this.xRot = this.getFormatted(player.field_70125_A);
        this.yRot = this.getFormatted(player.field_70177_z);
        this.dimensionName = player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a();
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    public void setDimensionName(@Nonnull String dimensionName) {
        this.dimensionName = dimensionName;
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    public boolean addInvitePlayer(@Nonnull UUID playerUUID) {
        if (!this.invitePlayers.add(playerUUID)) {
            return false;
        }
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
        return true;
    }

    public boolean removeInvitePlayer(@Nonnull UUID playerUUID) {
        if (!this.invitePlayers.remove(playerUUID)) {
            return false;
        }
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
        return true;
    }

    public boolean addBlacklistPlayer(@Nonnull UUID playerUUID) {
        if (!this.blacklistPlayers.add(playerUUID)) {
            return false;
        }
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
        return true;
    }

    public boolean removeBlacklistPlayer(@Nonnull UUID playerUUID) {
        if (!this.blacklistPlayers.remove(playerUUID)) {
            return false;
        }
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
        return true;
    }

    public boolean addUniquePlayer(@Nonnull UUID playerUUID) {
        if (!this.uniquePlayers.add(playerUUID)) {
            return false;
        }
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
        return true;
    }

    public void setWelcomeText(@Nullable String text) {
        this.welcomeText = text == null ? "" : text;
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        ExtraWarp.getInstance().getWarpProvider().updateStorage();
    }

    private double getFormatted(double value) {
        return Double.parseDouble(String.format("%.2f", value));
    }

    private float getFormatted(float value) {
        return (float)Math.round(value * 100.0f) / 100.0f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.name.equalsIgnoreCase(((Warp)object).name);
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }
}

