/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.config;

import com.google.common.collect.Sets;
import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extrawarp.ExtraWarp;
import java.util.Set;

public class ServerConfig {
    private static final int CURRENT_CONFIG_VERSION = 1;
    private int configVersion = 1;
    private int baseCountWarp = 2;
    private int maxMaxCharactersWarp = 10;
    private Set<String> blockedNamesWarp = Sets.newHashSet((Object[])new String[]{"Name"});
    private Set<String> permissionList = Sets.newHashSet((Object[])new String[]{"extrawarp.count.3", "extrawarp.count.5", "extrawarp.count.7"});

    public int getConfigVersion() {
        return this.configVersion;
    }

    public int getBaseCountWarp() {
        return this.baseCountWarp;
    }

    public int getMaxMaxCharactersWarp() {
        return this.maxMaxCharactersWarp;
    }

    public Set<String> getBlockedNamesWarp() {
        return this.blockedNamesWarp;
    }

    public Set<String> getPermissionList() {
        return this.permissionList;
    }

    private void write() {
        UtilGson.writeFileAsync((String)"/config/ExtraWarp/", (String)"config.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    public void init() {
        boolean completed = (Boolean)UtilGson.readFileAsync((String)"/config/ExtraWarp/", (String)"config.json", el -> {
            ServerConfig config = (ServerConfig)UtilGson.newGson().fromJson(el, ServerConfig.class);
            this.configVersion = config.getConfigVersion();
            this.baseCountWarp = config.getBaseCountWarp();
            this.maxMaxCharactersWarp = config.getMaxMaxCharactersWarp();
            this.blockedNamesWarp = config.getBlockedNamesWarp();
            this.permissionList = config.getPermissionList();
        }).join();
        if (!completed) {
            ExtraWarp.getLogger().error("Error init config, generating new config.");
            this.write();
        }
    }
}

