/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.api.factory;

import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.events.WarpEvent;
import com.vecoo.extrawarp.storage.warp.Warp;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraWarpFactory {
    public static boolean teleportWarp(@NotNull ServerPlayer player, @NotNull Warp warp) {
        ServerLevel level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            return false;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(warp.getX(), warp.getY(), warp.getZ());
        if (!player.m_150110_().f_35935_ && (blockPos = ExtraWarpFactory.findPosition(blockPos, level)) == null) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new WarpEvent.Teleport(warp, player))) {
            return false;
        }
        player.m_8999_(level, warp.getX(), (double)blockPos.m_123342_(), warp.getZ(), warp.getYRot(), warp.getXRot());
        player.m_20256_(Vec3.f_82478_);
        return true;
    }

    @Nullable
    private static BlockPos.MutableBlockPos findPosition(@NotNull BlockPos.MutableBlockPos blockPos, @NotNull ServerLevel level) {
        ChunkAccess chunk = level.m_7726_().m_7587_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, ChunkStatus.f_62322_, true);
        if (chunk == null) {
            return null;
        }
        while (blockPos.m_123342_() > level.m_141937_() && chunk.m_8055_((BlockPos)blockPos).m_60795_()) {
            blockPos.m_122173_(Direction.DOWN);
        }
        if (blockPos.m_123342_() <= level.m_141937_()) {
            return null;
        }
        if (!chunk.m_8055_((BlockPos)blockPos).m_60812_((BlockGetter)chunk, (BlockPos)blockPos).m_83281_()) {
            blockPos.m_122173_(Direction.UP);
        }
        return blockPos;
    }

    public static class WarpProvider {
        @NotNull
        public static Set<Warp> getWarps() {
            return ExtraWarp.getInstance().getWarpProvider().getStorage();
        }

        public static boolean hasWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static Warp getWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return warp;
            }
            return null;
        }

        @NotNull
        public static Set<Warp> getWarpsByPlayer(@NotNull UUID playerUUID) {
            HashSet<Warp> warps = new HashSet<Warp>();
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getOwnerUUID().equals(playerUUID)) continue;
                warps.add(warp);
            }
            return warps;
        }

        public static boolean addWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().addWarp(warp);
        }

        public static boolean removeWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().removeWarp(warp);
        }
    }
}

