/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.vecoo.extrawarp.command.WarpCommand;
import com.vecoo.extrawarp.config.LocaleConfig;
import com.vecoo.extrawarp.config.ServerConfig;
import com.vecoo.extrawarp.storage.warp.WarpProvider;
import com.vecoo.extrawarp.util.PermissionNodes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.slf4j.Logger;

@Mod(value="extrawarp")
public class ExtraWarp {
    public static final String MOD_ID = "extrawarp";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraWarp instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private WarpProvider warpProvider;
    private MinecraftServer server;

    public ExtraWarp() {
        instance = this;
        this.loadConfig();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes event) {
        PermissionNodes.registerPermission(event);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        WarpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
        this.loadStorage();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.warpProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.warpProvider == null) {
                this.warpProvider = new WarpProvider("/%directory%/storage/ExtraWarp/", this.server);
            }
            this.warpProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    public static ExtraWarp getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraWarp.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraWarp.instance.locale;
    }

    public WarpProvider getWarpProvider() {
        return ExtraWarp.instance.warpProvider;
    }

    public MinecraftServer getServer() {
        return ExtraWarp.instance.server;
    }
}

