/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.api.factory;

import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.events.WarpEvent;
import com.vecoo.extrawarp.storage.warp.Warp;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraWarpFactory {
    public static boolean teleportWarp(@NotNull ServerPlayer player, @NotNull Warp warp) {
        ServerLevel level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            return false;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(warp.getX(), warp.getY(), warp.getZ());
        if (!player.getAbilities().flying && (blockPos = ExtraWarpFactory.findPosition(blockPos, level)) == null) {
            return false;
        }
        if (((WarpEvent.Teleport)NeoForge.EVENT_BUS.post((Event)new WarpEvent.Teleport(warp, player))).isCanceled()) {
            return false;
        }
        player.teleportTo(level, warp.getX(), (double)blockPos.getY(), warp.getZ(), warp.getYRot(), warp.getXRot());
        player.setDeltaMovement(Vec3.ZERO);
        return true;
    }

    @Nullable
    private static BlockPos.MutableBlockPos findPosition(@NotNull BlockPos.MutableBlockPos blockPos, @NotNull ServerLevel level) {
        ChunkAccess chunk = level.getChunkSource().getChunk(blockPos.getX() >> 4, blockPos.getZ() >> 4, ChunkStatus.FEATURES, true);
        if (chunk == null) {
            return null;
        }
        while (blockPos.getY() > level.getMinBuildHeight() && chunk.getBlockState((BlockPos)blockPos).isAir()) {
            blockPos.move(Direction.DOWN);
        }
        if (blockPos.getY() < level.getMinBuildHeight()) {
            return null;
        }
        if (!chunk.getBlockState((BlockPos)blockPos).getCollisionShape((BlockGetter)chunk, (BlockPos)blockPos).isEmpty()) {
            blockPos.move(Direction.UP);
        }
        return blockPos;
    }

    public static class WarpProvider {
        @NotNull
        public static Set<Warp> getWarps() {
            return ExtraWarp.getInstance().getWarpProvider().getStorage();
        }

        public static boolean hasWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static Warp getWarpByName(@NotNull String warpName) {
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return warp;
            }
            return null;
        }

        @NotNull
        public static Set<Warp> getWarpsByPlayer(@NotNull UUID playerUUID) {
            HashSet<Warp> warps = new HashSet<Warp>();
            for (Warp warp : WarpProvider.getWarps()) {
                if (!warp.getOwnerUUID().equals(playerUUID)) continue;
                warps.add(warp);
            }
            return warps;
        }

        public static boolean addWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().addWarp(warp);
        }

        public static boolean removeWarp(@NotNull Warp warp) {
            return ExtraWarp.getInstance().getWarpProvider().removeWarp(warp);
        }
    }
}

