/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrawarp.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extralib.server.UtilCommand;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrawarp.ExtraWarp;
import com.vecoo.extrawarp.api.factory.ExtraWarpFactory;
import com.vecoo.extrawarp.config.LocaleConfig;
import com.vecoo.extrawarp.storage.warp.Warp;
import com.vecoo.extrawarp.util.PermissionNodes;
import com.vecoo.extrawarp.util.Utils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.UsernameCache;
import org.jetbrains.annotations.NotNull;

public class WarpCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warp").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_COMMAND))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.execute(StringArgumentType.getString((CommandContext)e, (String)"name"), ((CommandSourceStack)e.getSource()).getPlayerOrException())))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_SET_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSourceStack)e.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"pset").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.PRIVATE_WARP_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executePrivateSet(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSourceStack)e.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_DELETE_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeDelete(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSourceStack)e.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"private").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_PRIVATE_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePrivate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSourceStack)e.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"invite").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_INVITE_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(UtilCommand.suggestOnlinePlayers()).executes(e -> WarpCommand.executeInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSourceStack)e.getSource()).getPlayerOrException())))))).then(((LiteralArgumentBuilder)Commands.literal((String)"uninvite").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_UNINVITE_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                for (UUID playerUUID : warp.getInvitePlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)playerUUID);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUnInvite(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSourceStack)e.getSource()).getPlayerOrException())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blacklist").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_BLACKLIST_COMMAND))).then(Commands.literal((String)"add").then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(UtilCommand.suggestOnlinePlayers()).executes(e -> WarpCommand.executeAddBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSourceStack)e.getSource()).getPlayerOrException())))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                for (UUID playerUUID : warp.getBlacklistPlayers()) {
                    String name = UtilPlayer.getPlayerName((UUID)playerUUID);
                    if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveBlacklist(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"player"), ((CommandSourceStack)e.getSource()).getPlayerOrException()))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"public").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_PUBLIC_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.isLocked() || !warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executePublic(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSourceStack)e.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"rename").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_RENAME_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeRename(StringArgumentType.getString((CommandContext)e, (String)"warp"), StringArgumentType.getString((CommandContext)e, (String)"name"), (CommandSourceStack)e.getSource())))))).then(((LiteralArgumentBuilder)Commands.literal((String)"welcome").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_WELCOME_COMMAND))).then(((RequiredArgumentBuilder)Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeRemoveWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSourceStack)e.getSource()))).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(e -> WarpCommand.executeSetWelcome(StringArgumentType.getString((CommandContext)e, (String)"warp"), MessageArgument.getMessage((CommandContext)e, (String)"message"), (CommandSourceStack)e.getSource())))))).then(Commands.literal((String)"help").executes(e -> WarpCommand.executeHelp((CommandSourceStack)e.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_RELOAD_COMMAND))).executes(e -> WarpCommand.executeReload((CommandSourceStack)e.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"assets").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_ASSETS_COMMAND))).executes(e -> WarpCommand.executeAssets(((CommandSourceStack)e.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_ASSETS_PLAYER_COMMAND))).suggests(UtilCommand.suggestOnlinePlayers()).executes(e -> WarpCommand.executeAssetsPlayer((CommandSourceStack)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"top").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_TOP_COMMAND))).executes(e -> WarpCommand.executeTop((CommandSourceStack)e.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_INFO_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).executes(e -> WarpCommand.executeInfo(StringArgumentType.getString((CommandContext)e, (String)"warp"), (CommandSourceStack)e.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"update").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.WARP_UPDATE_COMMAND))).then(Commands.argument((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (Warp warp : ExtraWarpFactory.WarpProvider.getWarpsByPlayer(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                if (!warp.getName().toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(warp.getName());
            }
            return builder.buildFuture();
        }).executes(e -> WarpCommand.executeUpdate(StringArgumentType.getString((CommandContext)e, (String)"warp"), ((CommandSourceStack)e.getSource()).getPlayerOrException())))));
    }

    private static int execute(@NotNull String name, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isPlayerInvitedWarp(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPrivate().replace("%warp%", name)));
            return 0;
        }
        if (WarpCommand.isPlayerBlacklistedWarp(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getBlacklistWarp().replace("%warp%", name)));
            return 0;
        }
        ServerLevel level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotDimension().replace("%warp%", warp.getName())));
            return 0;
        }
        if (WarpCommand.isWarpBeyondWorld(warp, (Level)level)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.teleportWarp(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.addUniquePlayer(player.getUUID());
        if (warp.getWelcomeText().isEmpty()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getTeleportWarp().replace("%warp%", warp.getName())));
        } else {
            player.sendSystemMessage(UtilChat.formatMessage((String)(localeConfig.getAddWelcome() + warp.getWelcomeText())));
        }
        return 1;
    }

    private static int executeSet(@NotNull String name, @NotNull ServerPlayer player) {
        int maxWarps = Utils.maxCountWarp(player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (WarpCommand.isLimitWarp(player, maxWarps)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarps))));
            return 0;
        }
        if (Utils.isBlockedNameWarp(name)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()));
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, false))) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        player.sendSystemMessage((Component)UtilChat.formatMessage((String)localeConfig.getSetWarp().replace("%warp%", name)).copy().append((Component)UtilChat.clickableMessageCommand((String)localeConfig.getSetWarpAdditional(), (String)("/warp private " + name)).copy().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverSetToPrivateWarp() + name)))))));
        return 1;
    }

    private static int executePrivateSet(@NotNull String name, @NotNull ServerPlayer player) {
        int maxWarps = Utils.maxCountWarp(player);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (WarpCommand.isLimitWarp(player, maxWarps)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getMaxWarp().replace("%count%", String.valueOf(maxWarps))));
            return 0;
        }
        if (Utils.isBlockedNameWarp(name)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getInvalidWarpArgument()));
            return 0;
        }
        if (name.length() > ExtraWarp.getInstance().getConfig().getMaxMaxCharactersWarp()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpMaxCharacters()));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(name)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.addWarp(new Warp(name, player, true))) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getSetWarpPrivate().replace("%warp%", name)));
        return 1;
    }

    private static int executeDelete(@NotNull String name, @NotNull CommandSourceStack source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(source, warp)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!ExtraWarpFactory.WarpProvider.removeWarp(warp)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpError().replace("%warp%", name)));
            return 0;
        }
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpRemoved().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeInfo(@NotNull String name, @NotNull CommandSourceStack source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        HashSet<String> playerInviteName = new HashSet<String>();
        HashSet<String> playerBlacklistName = new HashSet<String>();
        for (UUID playerUUID : warp.getInvitePlayers()) {
            if (!UsernameCache.containsUUID((UUID)playerUUID)) continue;
            playerInviteName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        for (UUID playerUUID : warp.getBlacklistPlayers()) {
            if (!UsernameCache.containsUUID((UUID)playerUUID)) continue;
            playerBlacklistName.add(UtilPlayer.getPlayerName((UUID)playerUUID));
        }
        ServerPlayer player = source.getPlayer();
        boolean hideXYZ = warp.isLocked() && player != null && !UtilPermission.hasPermission((ServerPlayer)player, PermissionNodes.WARP_BYPASS) && !warp.getOwnerUUID().equals(player.getUUID()) && !warp.getInvitePlayers().contains(player.getUUID());
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getInfoWarp().replace("%warp%", warp.getName()).replace("%owner%", UtilPlayer.getPlayerName((UUID)warp.getOwnerUUID())).replace("%x%", hideXYZ ? "-" : String.valueOf(warp.getX())).replace("%y%", hideXYZ ? "-" : String.valueOf(warp.getY())).replace("%z%", hideXYZ ? "-" : String.valueOf(warp.getZ())).replace("%dimension%", warp.getDimensionName()).replace("%invitePlayers%", ((Object)playerInviteName).toString()).replace("%blacklistPlayers%", ((Object)playerBlacklistName).toString()).replace("%count%", String.valueOf(warp.getUniquePlayers().size())).replace("%locked%", warp.isLocked() ? localeConfig.getLocked() : localeConfig.getUnlocked())));
        return 1;
    }

    private static int executeUpdate(@NotNull String name, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        ServerLevel level = UtilWorld.getLevelByName((String)warp.getDimensionName());
        if (level == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotDimension().replace("%warp%", warp.getName())));
            return 0;
        }
        if (WarpCommand.isWarpBeyondWorld(warp, (Level)level)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpBorder().replace("%warp%", name)));
            return 0;
        }
        warp.updatePosition(player);
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpUpdate().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeRename(@NotNull String name, @NotNull String newName, @NotNull CommandSourceStack source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(source, warp)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getName().equals(newName)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getEqualsRename().replace("%warp%", warp.getName())));
            return 0;
        }
        if (ExtraWarpFactory.WarpProvider.hasWarpByName(newName)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", newName)));
            return 0;
        }
        warp.setName(newName);
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpRename().replace("%warp%", warp.getName()).replace("%name%", newName)));
        return 1;
    }

    private static int executePrivate(@NotNull String name, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (warp.isLocked()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPrivated().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setLocked(true);
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPrivateWarp().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executePublic(@NotNull String name, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpExist().replace("%warp%", name)));
            return 0;
        }
        if (!warp.isLocked()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPubliced().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setLocked(false);
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPublicWarp().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeInvite(@NotNull String name, @NotNull String playerName, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.getUUID().equals(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.addInvitePlayer(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        UtilPlayer.sendMessageUuid((UUID)targetUUID, (Component)UtilChat.formatMessage((String)localeConfig.getInvitedWarp().replace("%warp%", warp.getName()).replace("%player%", player.getName().getString())));
        return 1;
    }

    private static int executeUnInvite(@NotNull String name, @NotNull String playerName, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.getUUID().equals(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.removeInvitePlayer(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getUnInviteWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeAddBlacklist(@NotNull String name, @NotNull String playerName, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(player, warp)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.getUUID().equals(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.addBlacklistPlayer(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getBlacklistAddedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeRemoveBlacklist(@NotNull String name, @NotNull String playerName, @NotNull ServerPlayer player) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        if (targetUUID == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        if (!warp.getOwnerUUID().equals(player.getUUID())) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (player.getUUID().equals(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotYourself().replace("%warp%", warp.getName())));
            return 0;
        }
        if (!warp.removeBlacklistPlayer(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpPlayerAlready().replace("%warp%", warp.getName()).replace("%player%", playerName)));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getBlacklistRemovedWarp().replace("%warp%", warp.getName()).replace("%player%", playerName)));
        return 1;
    }

    private static int executeAssets(@NotNull ServerPlayer player) {
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.getUUID());
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        player.sendSystemMessage(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getWarpAssets().replace("%count%", String.valueOf(warps.size())).replace("%maxCount%", String.valueOf(Utils.maxCountWarp(player))).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)));
        return 1;
    }

    private static int executeAssetsPlayer(@NotNull CommandSourceStack source, @NotNull String playerName) {
        UUID targetUUID = UtilPlayer.getUUID((String)playerName);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (targetUUID == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", playerName)));
            return 0;
        }
        Set<Warp> warps = ExtraWarpFactory.WarpProvider.getWarpsByPlayer(targetUUID);
        String publicWarps = warps.stream().filter(warp -> !warp.isLocked()).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        String privateWarps = warps.stream().filter(Warp::isLocked).map(Warp::getName).sorted().collect(Collectors.joining(", "));
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpAssetsPlayer().replace("%player%", playerName).replace("%publicWarps%", publicWarps).replace("%privateWarps%", privateWarps)));
        return 1;
    }

    private static int executeTop(@NotNull CommandSourceStack source) {
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        List<Warp> topWarps = ExtraWarpFactory.WarpProvider.getWarps().stream().filter(warp -> !warp.isLocked()).sorted(Comparator.comparingInt(warp -> warp.getUniquePlayers().size()).reversed()).limit(10L).toList();
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getTopWarpTitle()));
        for (int i = 0; i < topWarps.size(); ++i) {
            Warp warp2 = topWarps.get(i);
            source.sendSystemMessage((Component)UtilChat.clickableMessageCommand((String)localeConfig.getTopWarp().replace("%place%", localeConfig.getPlaces().get(i)).replace("%warp%", warp2.getName()).replace("%player%", UtilPlayer.getPlayerName((UUID)warp2.getOwnerUUID())), (String)("/warp " + warp2.getName())).copy().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)UtilChat.formatMessage((String)(localeConfig.getHoverTopWarp() + warp2.getName()))))));
        }
        return 1;
    }

    private static int executeSetWelcome(@NotNull String name, Component component, @NotNull CommandSourceStack source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(source, warp)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setWelcomeText(component.getString());
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpSetWelcome().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeRemoveWelcome(@NotNull String name, @NotNull CommandSourceStack source) {
        Warp warp = ExtraWarpFactory.WarpProvider.getWarpByName(name);
        LocaleConfig localeConfig = ExtraWarp.getInstance().getLocale();
        if (warp == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotFound().replace("%warp%", name)));
            return 0;
        }
        if (!WarpCommand.isWarpOwner(source, warp)) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpNotOwner().replace("%warp%", warp.getName())));
            return 0;
        }
        if (warp.getWelcomeText().isEmpty()) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpWelcomeEmpty().replace("%warp%", warp.getName())));
            return 0;
        }
        warp.setWelcomeText(null);
        source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getWarpRemoveWelcome().replace("%warp%", warp.getName())));
        return 1;
    }

    private static int executeHelp(@NotNull CommandSourceStack source) {
        source.sendSystemMessage(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getHelp()));
        return 1;
    }

    private static int executeReload(@NotNull CommandSourceStack source) {
        ExtraWarp.getInstance().loadConfig();
        ExtraWarp.getInstance().loadStorage();
        source.sendSystemMessage(UtilChat.formatMessage((String)ExtraWarp.getInstance().getLocale().getReload()));
        return 1;
    }

    private static boolean isPlayerBlacklistedWarp(@NotNull ServerPlayer player, @NotNull Warp warp) {
        return warp.getBlacklistPlayers().contains(player.getUUID()) && !UtilPermission.hasPermission((ServerPlayer)player, PermissionNodes.WARP_BYPASS);
    }

    private static boolean isPlayerInvitedWarp(@NotNull ServerPlayer player, @NotNull Warp warp) {
        return !warp.isLocked() || warp.getOwnerUUID().equals(player.getUUID()) || warp.getInvitePlayers().contains(player.getUUID()) || UtilPermission.hasPermission((ServerPlayer)player, PermissionNodes.WARP_BYPASS);
    }

    private static boolean isLimitWarp(@NotNull ServerPlayer player, int maxCount) {
        return ExtraWarpFactory.WarpProvider.getWarpsByPlayer(player.getUUID()).size() >= maxCount && !UtilPermission.hasPermission((ServerPlayer)player, PermissionNodes.WARP_BYPASS);
    }

    private static boolean isWarpOwner(@NotNull CommandSourceStack source, @NotNull Warp warp) {
        return source.getEntity() == null || warp.getOwnerUUID().equals(source.getEntity().getUUID()) || UtilPermission.hasPermission((CommandSourceStack)source, PermissionNodes.WARP_BYPASS);
    }

    private static boolean isWarpOwner(@NotNull ServerPlayer player, @NotNull Warp warp) {
        return warp.getOwnerUUID().equals(player.getUUID()) || UtilPermission.hasPermission((ServerPlayer)player, PermissionNodes.WARP_BYPASS);
    }

    private static boolean isWarpBeyondWorld(@NotNull Warp warp, @NotNull Level level) {
        return warp.getX() >= level.getWorldBorder().getMaxX() || warp.getY() < (double)level.getMinBuildHeight() || warp.getY() > (double)level.getMaxBuildHeight() || warp.getZ() >= level.getWorldBorder().getMaxZ();
    }
}

