/*
 * Decompiled with CFR 0.152.
 */
package com.ashaxolotl.partytrick.spell.trick.color;

import com.ashaxolotl.partytrick.misc.ColorHelper;
import dev.enjarai.trickster.block.SpellColoredBlockEntity;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ItemTypeFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import dev.enjarai.trickster.spell.type.RetType;
import dev.enjarai.trickster.spell.type.Signature;
import io.vavr.control.Either;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1451;
import net.minecraft.class_1472;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class GetColorTrick
extends Trick<GetColorTrick> {
    public GetColorTrick() {
        super(Pattern.of((int[])new int[]{0, 3, 6, 4, 0, 5, 6}), Signature.of((ArgType)FragmentType.VECTOR, GetColorTrick::getBlockColor, (RetType)FragmentType.VECTOR.or((RetType)FragmentType.ITEM_TYPE).optionalOfRet()));
        this.overload(Signature.of((ArgType)FragmentType.ENTITY, GetColorTrick::getEntityColor, (RetType)FragmentType.ITEM_TYPE.optionalOfRet()));
        this.overload(Signature.of((ArgType)FragmentType.ITEM_TYPE, GetColorTrick::getItemColor, (RetType)FragmentType.ITEM_TYPE.optionalOfRet()));
    }

    public Optional<Either<VectorFragment, ItemTypeFragment>> getBlockColor(SpellContext ctx, VectorFragment pos) throws BlunderException {
        class_2338 blockPos = pos.toBlockPos();
        class_3218 world = ctx.source().getWorld();
        class_2586 entity = world.method_8321(blockPos);
        if (entity instanceof SpellColoredBlockEntity) {
            SpellColoredBlockEntity blockEntity = (SpellColoredBlockEntity)entity;
            Color color = new Color(blockEntity.getColors()[0]);
            return Optional.of(Either.left((Object)new VectorFragment((Vector3dc)new Vector3d((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue()))));
        }
        String colorString = ColorHelper.getDyeColorString(class_7923.field_41175.method_10221((Object)world.method_8320(blockPos).method_26204()));
        if (colorString.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Either.right((Object)new ItemTypeFragment((class_1792)class_1769.method_7803((class_1767)class_1767.valueOf((String)colorString.toUpperCase())))));
    }

    public Optional<ItemTypeFragment> getEntityColor(SpellContext ctx, EntityFragment entityFragment) throws BlunderException {
        class_1451 cat;
        class_1493 wolf;
        class_1297 entity = (class_1297)entityFragment.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder((Trick)this));
        if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            return Optional.of(new ItemTypeFragment((class_1792)class_1769.method_7803((class_1767)sheep.method_6633())));
        }
        if (entity instanceof class_1493 && (wolf = (class_1493)entity).method_6181()) {
            ctx.useMana((Trick)this, 20.0f);
            return Optional.of(new ItemTypeFragment((class_1792)class_1769.method_7803((class_1767)wolf.method_6713())));
        }
        if (entity instanceof class_1451 && (cat = (class_1451)entity).method_6181()) {
            ctx.useMana((Trick)this, 20.0f);
            return Optional.of(new ItemTypeFragment((class_1792)class_1769.method_7803((class_1767)cat.method_16096())));
        }
        return Optional.empty();
    }

    public Optional<ItemTypeFragment> getItemColor(SpellContext ctx, ItemTypeFragment itemTypeFragment) throws BlunderException {
        String colorString = ColorHelper.getDyeColorString(class_7923.field_41178.method_10221((Object)itemTypeFragment.item()));
        if (colorString.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ItemTypeFragment((class_1792)class_1769.method_7803((class_1767)class_1767.valueOf((String)colorString.toUpperCase()))));
    }
}

