/*
 * Decompiled with CFR 0.152.
 */
package com.ashaxolotl.partytrick.cca;

import com.ashaxolotl.partytrick.cca.ModEntityComponents;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class MufflesComponent
implements ServerTickingComponent,
AutoSyncedComponent {
    public static final int STAY_FOR_TICKS = 100;
    public static final Endec<List<Muffle>> MUFFLES_ENDEC = Muffle.ENDEC.listOf();
    private final class_1657 player;
    private final List<Muffle> muffles = new ArrayList<Muffle>();
    private int lastBarsHashcode;
    private class_5321<class_1937> lastPlayerWorld;

    public MufflesComponent(class_1657 player) {
        this.player = player;
    }

    public void serverTick() {
        Iterator<Muffle> iterator = this.muffles.iterator();
        while (iterator.hasNext()) {
            Muffle entry = iterator.next();
            if (entry.age >= 100) {
                iterator.remove();
                continue;
            }
            ++entry.age;
        }
        ModEntityComponents.MUFFLES.sync((Object)this.player);
    }

    public List<Muffle> getMuffles() {
        return this.muffles;
    }

    public void addMuffle(Optional<List<class_2960>> sounds, double amount) {
        this.muffles.add(new Muffle(sounds, amount));
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        if (player != this.player) {
            return false;
        }
        int hash = this.muffles.hashCode();
        class_5321 worldKey = player.method_37908().method_27983();
        if (hash != this.lastBarsHashcode || worldKey != this.lastPlayerWorld) {
            this.lastBarsHashcode = hash;
            this.lastPlayerWorld = worldKey;
            return true;
        }
        return false;
    }

    public void applySyncPacket(class_9129 buf) {
        this.muffles.clear();
        this.muffles.addAll((Collection)buf.read(MUFFLES_ENDEC));
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.write(MUFFLES_ENDEC, this.muffles);
    }

    public static class Muffle {
        public static final Endec<Muffle> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.listOf().optionalOf().fieldOf("sounds", m -> m.sounds), (StructField)Endec.DOUBLE.fieldOf("amount", m -> m.amount), Muffle::new);
        public Optional<List<class_2960>> sounds;
        public double amount;
        public int age;

        public Muffle(Optional<List<class_2960>> sounds, double amount) {
            this(sounds, amount, 0);
        }

        public Muffle(Optional<List<class_2960>> sounds, double amount, int age) {
            this.sounds = sounds;
            this.amount = amount;
            this.age = age;
        }
    }
}

