/*
 * Decompiled with CFR 0.152.
 */
package com.ashaxolotl.partytrick.spell.trick.color;

import com.ashaxolotl.partytrick.misc.ColorHelper;
import com.ashaxolotl.partytrick.misc.Tags;
import com.ashaxolotl.partytrick.spell.blunder.ColorVectorInvalidRangeBlunder;
import dev.enjarai.trickster.block.SpellColoredBlockEntity;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlockInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.InvalidEntityBlunder;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ItemTypeFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import dev.enjarai.trickster.spell.type.RetType;
import dev.enjarai.trickster.spell.type.Signature;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1451;
import net.minecraft.class_1472;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_7225;

public class ChangeColorTrick
extends Trick<ChangeColorTrick> {
    private static final int manaCost = 40;

    public ChangeColorTrick() {
        super(Pattern.of((int[])new int[]{2, 4, 6, 1, 8, 6}), Signature.of((ArgType)FragmentType.VECTOR, (ArgType)FragmentType.VECTOR, ChangeColorTrick::changeBlockWithVector, (RetType)FragmentType.VECTOR));
        this.overload(Signature.of((ArgType)FragmentType.VECTOR, (ArgType)FragmentType.ITEM_TYPE.optionalOfArg(), ChangeColorTrick::changeBlockWithDye, (RetType)FragmentType.VECTOR));
        this.overload(Signature.of((ArgType)FragmentType.SLOT, (ArgType)FragmentType.ITEM_TYPE.optionalOfArg(), ChangeColorTrick::changeSlot, (RetType)FragmentType.SLOT));
        this.overload(Signature.of((ArgType)FragmentType.ENTITY, (ArgType)FragmentType.ITEM_TYPE, ChangeColorTrick::changeEntity, (RetType)FragmentType.ENTITY));
    }

    public VectorFragment changeBlockWithDye(SpellContext ctx, VectorFragment pos, Optional<ItemTypeFragment> optionalDyeItem) throws BlunderException {
        class_1767 dyeColor;
        class_2338 blockPos = pos.toBlockPos();
        class_3218 world = ctx.source().getWorld();
        class_2680 blockState = world.method_8320(blockPos);
        this.expectLoaded(ctx, new class_2338[]{blockPos});
        if (blockState.method_26164(Tags.COLOR_BLOCK_BLACKLIST)) {
            throw new BlockInvalidBlunder((Trick)this);
        }
        if (optionalDyeItem.isEmpty()) {
            dyeColor = null;
        } else {
            class_1792 class_17922 = optionalDyeItem.get().item();
            if (!(class_17922 instanceof class_1769)) {
                throw new ItemInvalidBlunder((Trick)this);
            }
            class_1769 dye = (class_1769)class_17922;
            dyeColor = dye.method_7802();
        }
        class_2680 newBlockState = ColorHelper.getBlockColorVariant(blockState, dyeColor);
        if (newBlockState.method_26215()) {
            throw new BlockInvalidBlunder((Trick)this);
        }
        ctx.useMana((Trick)this, 40.0f);
        class_2487 blockEntityNbt = null;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            blockEntityNbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        }
        if (newBlockState != blockState) {
            world.method_8501(blockPos, newBlockState);
        }
        if (blockEntity != null) {
            world.method_8321(blockPos).method_58690(blockEntityNbt, (class_7225.class_7874)world.method_30349());
        }
        return pos;
    }

    public SlotFragment changeSlot(SpellContext ctx, SlotFragment slot, Optional<ItemTypeFragment> optionalDyeItem) throws BlunderException {
        class_1767 dyeColor;
        if (optionalDyeItem.isEmpty()) {
            dyeColor = null;
        } else {
            class_1792 class_17922 = optionalDyeItem.get().item();
            if (!(class_17922 instanceof class_1769)) {
                throw new ItemInvalidBlunder((Trick)this);
            }
            class_1769 dye = (class_1769)class_17922;
            dyeColor = dye.method_7802();
        }
        class_1799 itemStack = slot.reference((Trick)this, ctx);
        if (itemStack.method_31573(Tags.COLOR_ITEM_BLACKLIST)) {
            throw new ItemInvalidBlunder((Trick)this);
        }
        class_1799 newItemStack = ColorHelper.getItemColorVariant(itemStack, dyeColor);
        class_1792 newItem = newItemStack.method_7909();
        if (newItem == class_1802.field_8162) {
            throw new ItemInvalidBlunder((Trick)this);
        }
        ctx.useMana((Trick)this, (float)(40 * itemStack.method_7947()));
        if (itemStack.method_7909() != newItem) {
            slot.setStack(newItemStack, (Trick)this, ctx);
        }
        return slot;
    }

    public VectorFragment changeBlockWithVector(SpellContext ctx, VectorFragment pos, VectorFragment colorVector) throws BlunderException {
        class_2338 blockPos = pos.toBlockPos();
        class_3218 world = ctx.source().getWorld();
        if (colorVector.x() < 0.0 || colorVector.x() > 255.0 || colorVector.y() < 0.0 || colorVector.y() > 255.0 || colorVector.z() < 0.0 || colorVector.z() > 255.0) {
            throw new ColorVectorInvalidRangeBlunder(this, colorVector);
        }
        int[] color = new int[]{new Color((int)colorVector.x(), (int)colorVector.y(), (int)colorVector.z()).getRGB()};
        class_2586 entity = world.method_8321(blockPos);
        if (!(entity instanceof SpellColoredBlockEntity)) {
            throw new BlockInvalidBlunder((Trick)this);
        }
        SpellColoredBlockEntity blockEntity = (SpellColoredBlockEntity)entity;
        blockEntity.setColors(color);
        class_2680 chachedState = ((class_2586)blockEntity).method_11010();
        world.method_8413(blockPos, chachedState, chachedState, 0);
        return pos;
    }

    public EntityFragment changeEntity(SpellContext ctx, EntityFragment entityFragment, ItemTypeFragment dyeItem) throws BlunderException {
        class_1451 cat;
        class_1493 wolf;
        class_1792 class_17922 = dyeItem.item();
        if (!(class_17922 instanceof class_1769)) {
            throw new ItemInvalidBlunder((Trick)this);
        }
        class_1769 dye = (class_1769)class_17922;
        class_1767 dyeColor = dye.method_7802();
        class_1297 entity = (class_1297)entityFragment.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder((Trick)this));
        if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            ctx.useMana((Trick)this, 40.0f);
            if (sheep.method_6633() == class_1767.field_7966 && dyeColor == class_1767.field_7964) {
                sheep.method_56078(class_3417.field_15058);
            }
            sheep.method_6631(dyeColor);
        } else if (entity instanceof class_1493 && (wolf = (class_1493)entity).method_6181()) {
            ctx.useMana((Trick)this, 40.0f);
            wolf.method_6708(dyeColor);
        } else if (entity instanceof class_1451 && (cat = (class_1451)entity).method_6181()) {
            ctx.useMana((Trick)this, 40.0f);
            cat.method_16094(dyeColor);
        } else {
            throw new InvalidEntityBlunder((Trick)this);
        }
        return entityFragment;
    }
}

