/*
 * Decompiled with CFR 0.152.
 */
package com.ashaxolotl.partytrick.spell.trick.projectile;

import com.ashaxolotl.partytrick.misc.Tags;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.EntityInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import dev.enjarai.trickster.spell.type.RetType;
import dev.enjarai.trickster.spell.type.Signature;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1673;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class SummonSpitTrick
extends Trick<SummonSpitTrick> {
    public SummonSpitTrick() {
        super(Pattern.of((int[])new int[]{0, 4, 8, 2, 4, 6, 0, 1, 2, 5, 8, 7, 6, 3, 0}), Signature.of((ArgType)FragmentType.VECTOR, SummonSpitTrick::fromCaster, (RetType)FragmentType.ENTITY));
        this.overload(Signature.of((ArgType)FragmentType.VECTOR, (ArgType)FragmentType.ENTITY, SummonSpitTrick::fromEntity, (RetType)FragmentType.ENTITY));
    }

    public EntityFragment fromCaster(SpellContext ctx, VectorFragment pos) throws BlunderException {
        class_1297 caster = (class_1297)ctx.source().getCaster().orElseThrow(() -> new NoPlayerBlunder((Trick)this));
        ctx.useMana((Trick)this, this.cost(ctx.source().getPos().distance(pos.vector())));
        class_3218 world = ctx.source().getWorld();
        class_1673 projectile = (class_1673)class_1299.field_6124.method_5883((class_1937)world);
        projectile.method_7432(caster);
        projectile.method_23327(pos.x(), pos.y(), pos.z());
        world.method_8649((class_1297)projectile);
        return EntityFragment.from((class_1297)projectile);
    }

    public EntityFragment fromEntity(SpellContext ctx, VectorFragment pos, EntityFragment entityFragment) throws BlunderException {
        class_1297 entity = (class_1297)entityFragment.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder((Trick)this));
        if (!(entity instanceof class_1309) || entity instanceof class_1657 || entity.method_5864().method_20210(Tags.SPIT_BLACKLIST)) {
            throw new EntityInvalidBlunder((Trick)this);
        }
        ctx.useMana((Trick)this, this.cost(entity.method_19538().method_1022(new class_243(pos.x(), pos.y(), pos.z()))));
        class_3218 world = ctx.source().getWorld();
        class_1673 projectile = (class_1673)class_1299.field_6124.method_5883((class_1937)world);
        projectile.method_7432(entity);
        projectile.method_23327(pos.x(), pos.y(), pos.z());
        world.method_8649((class_1297)projectile);
        return EntityFragment.from((class_1297)projectile);
    }

    private float cost(double dist) {
        return (float)(20.0 + Math.pow(dist, dist / 3.0));
    }
}

