/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.commands.BossChecklistCommands;
import com.yori3o.boss_checklist.config.ServerConfig;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import com.yori3o.boss_checklist.server.ServerBossIdsLoader;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class BossChecklist {
    public static final String MOD_ID = "boss_checklist";
    public static Set<String> defeated_bosses_on_server;
    public static boolean isSaveBossKiller_dynamic;

    public void init() {
        BossChecklistCommands.register();
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> BossChecklistClient.OnlyClientInit());
    }

    private void onServerStarted(MinecraftServer server) {
        ServerBossIdsLoader.load(server);
        defeated_bosses_on_server = BossDefeatedData.get(server.overworld()).getDefeatedBosses();
        ServerConfig sc = new ServerConfig();
        sc.load();
        isSaveBossKiller_dynamic = sc.isSaveBossKiller();
    }

    private void onPlayerJoin(ServerPlayer player) {
        RegistryAccess.Frozen registryAccess = player.server.registryAccess();
        for (String lineOfInformation : defeated_bosses_on_server) {
            FriendlyByteBuf originalBuf = new FriendlyByteBuf(Unpooled.buffer());
            RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)originalBuf, (RegistryAccess)registryAccess);
            registryBuf.writeUtf(lineOfInformation);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"boss_defeated"), (RegistryFriendlyByteBuf)registryBuf);
        }
    }

    public static void removeBossFromDefeated_bosses_on_server(String value) {
        HashSet<String> defeated_bosses_on_serverCopy = new HashSet<String>();
        for (String boss : defeated_bosses_on_server) {
            String bossId = boss.split("#")[0];
            LoggerUtil.LOGGER.info("checking all defeated bosses for removing from defeated_bosses_on_server - " + bossId);
            if (bossId.equals(value.split("#")[0])) continue;
            LoggerUtil.LOGGER.info("added boss to defeated_bosses_on_server copy " + bossId);
            defeated_bosses_on_serverCopy.add(boss);
        }
        defeated_bosses_on_server.clear();
        defeated_bosses_on_server.addAll(defeated_bosses_on_serverCopy);
    }
}

