/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.network.BossDefeatedPacket;
import com.yori3o.boss_checklist.server.BossDefeatedAndLoad;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossChecklist {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    public static final String MOD_ID = "boss_checklist";
    public static Boolean saveBossKiller = true;

    public void init() {
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> BossChecklistClient.OnlyClientInit());
    }

    private void onServerStarted(MinecraftServer server) {
        BossDefeatedAndLoad.load(server);
    }

    private void onPlayerJoin(ServerPlayer player) {
        ServerLevel overworld = player.server.overworld();
        Set<String> data = BossDefeatedData.get(overworld).getDefeatedBosses();
        RegistryAccess.Frozen registryAccess = overworld.getServer().registryAccess();
        for (String lineOfInformation : data) {
            FriendlyByteBuf originalBuf = new FriendlyByteBuf(Unpooled.buffer());
            RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)originalBuf, (RegistryAccess)registryAccess);
            registryBuf.writeUtf(lineOfInformation);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BossDefeatedPacket.BOSS_DEFEATED_PACKET, (RegistryFriendlyByteBuf)registryBuf);
        }
    }
}

