/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.gui.BossInfoScreen;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.client.gui.CustomPageButton;
import com.yori3o.boss_checklist.client.gui.TextUtil;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataClientSaver;
import com.yori3o.boss_checklist.data.BossRegistry;
import com.yori3o.boss_checklist.init.BossChecklistKeyMapping;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossChecklistScreen
extends Screen {
    private static final BossDataClientSaver DATA_SAVER = new BossDataClientSaver();
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final ResourceLocation bar_background = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/boss_bar/white_background.png");
    private static final ResourceLocation bar_progress = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/boss_bar/white_progress.png");
    private static final ResourceLocation background_texture = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/boss_book.png");
    private static final int ELEMENTS_PER_PAGE = 7;
    private int currentSpread = 0;
    private int maxTextWidth = 95;
    private List<BossData> bossDataList = new ArrayList<BossData>();
    private List<CustomCheckbox> currentCheckboxes = new ArrayList<CustomCheckbox>();
    private CustomPageButton nextButton;
    private CustomPageButton prevButton;
    private int leftPage;
    private int rightPage;
    private boolean skipNextRenderBackground = false;
    private boolean noBossesLoaded = false;
    private boolean bossesListAreLoaded = false;
    private List<Component> bosses = new ArrayList<Component>();
    private List<String> bossIds = new ArrayList<String>();
    private int defeatedCount;
    private int totalCount;
    private float percent;

    public BossChecklistScreen() {
        super((Component)Component.literal((String)"Checklist"));
    }

    public void init() {
        super.init();
        if (!this.bossesListAreLoaded) {
            this.bossesListAreLoaded = true;
            this.bossDataList = BossRegistry.all().stream().toList();
            this.bossIds.addAll(BossRegistry.all().stream().map(BossData::getId).toList());
            for (BossData b : this.bossDataList) {
                if (BossChecklistClient.hideUndefeatedBossInfo.booleanValue() && !BossDataClientSaver.defeatedBossesIds_InWorld.contains(b.getId())) {
                    this.bosses.add((Component)Component.literal((String)"???"));
                    continue;
                }
                String translated = Component.translatable((String)("boss_checklist.boss." + b.getId().replace(":", "_"))).getString();
                String truncated = TextUtil.truncateText(translated, this.maxTextWidth).getString();
                this.bosses.add((Component)Component.literal((String)truncated));
            }
        }
        this.updateCounts();
        this.createPageButtons();
        this.updatePage();
    }

    private void updateCounts() {
        this.defeatedCount = DATA_SAVER.defeatedBossesCount();
        this.totalCount = this.bossIds.size();
        this.percent = this.totalCount > 0 ? (float)this.defeatedCount / (float)this.totalCount : 0.0f;
    }

    private void createPageButtons() {
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        this.prevButton = new CustomPageButton(bookX + 138, bookY + 190, true, () -> {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
            }
        });
        this.nextButton = new CustomPageButton(bookX + 350, bookY + 190, false, () -> {
            if (this.currentSpread < totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.prevButton);
        this.addRenderableWidget((GuiEventListener)this.nextButton);
    }

    private void updatePage() {
        if (this.bosses.isEmpty()) {
            LOGGER.warn("No bosses loaded at checklist!");
            this.prevButton.visible = false;
            this.nextButton.visible = false;
            this.noBossesLoaded = true;
            return;
        }
        for (CustomCheckbox cb : this.currentCheckboxes) {
            this.removeWidget((GuiEventListener)cb);
        }
        this.currentCheckboxes.clear();
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        int fromIndex = this.currentSpread * 14;
        int toIndex = Math.min(fromIndex + 14, this.bosses.size());
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        int leftX = bookX + 134;
        int rightX = bookX + 266;
        int startY = bookY + 56;
        for (int i = fromIndex; i < toIndex; ++i) {
            String boss = this.bosses.get(i).getString();
            String bossId = this.bossIds.get(i);
            int localIndex = i - fromIndex;
            int x = localIndex < 7 ? leftX : rightX;
            int y = startY + localIndex % 7 * 18;
            CustomCheckbox cb = new CustomCheckbox(x, y, (Component)Component.literal((String)boss), DATA_SAVER.isBossDefeated(bossId), checked -> {
                BossDataClientSaver.BossDefeated(bossId, checked);
                this.updateCounts();
            }, () -> Minecraft.getInstance().setScreen((Screen)new BossInfoScreen(this, bossId)));
            this.addRenderableWidget((GuiEventListener)cb);
            this.currentCheckboxes.add(cb);
        }
        this.prevButton.visible = this.currentSpread > 0;
        this.nextButton.visible = this.currentSpread < totalSpreads - 1;
        this.leftPage = this.currentSpread * 2 + 1;
        this.rightPage = this.currentSpread * 2 + 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.skipNextRenderBackground = true;
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        guiGraphics.blit(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.blit(bar_background, bookX + 165, bookY + 29, 0.0f, 0.0f, 182, 5, 182, 5);
        guiGraphics.blit(bar_progress, bookX + 165, bookY + 29, 0.0f, 0.0f, (int)(this.percent * 182.0f), 5, 182, 5);
        guiGraphics.drawString(this.font, this.defeatedCount + " / " + this.totalCount, (this.width - Minecraft.getInstance().font.width(this.defeatedCount + " / " + this.totalCount)) / 2, bookY + 20, 0xFFFFFF, false);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.noBossesLoaded) {
            guiGraphics.drawString(this.font, "No bosses loaded!", bookX + 140, bookY + 53, 0, false);
        } else {
            guiGraphics.drawString(this.font, String.valueOf(this.leftPage), bookX + 187, bookY + 195, 0, false);
            guiGraphics.drawString(this.font, String.valueOf(this.rightPage), bookX + 320, bookY + 195, 0, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistKeyMapping.OPEN_CHECKLIST.matches(keyCode, scanCode)) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.skipNextRenderBackground) {
            this.skipNextRenderBackground = false;
            return;
        }
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }
}

