/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.commands.BossChecklistCommands;
import com.yori3o.boss_checklist.config.ServerConfig;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import com.yori3o.boss_checklist.server.ServerBossIdsLoader;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BossChecklist {
    public static final String MOD_ID = "boss_checklist";
    public static Set<String> defeated_bosses_on_server;
    public static boolean isSaveBossKiller_dynamic;

    public void init() {
        BossChecklistCommands.register();
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> BossChecklistClient.OnlyClientInit());
    }

    private void onServerStarted(MinecraftServer server) {
        ServerBossIdsLoader.load(server);
        defeated_bosses_on_server = BossDefeatedData.get(server.method_30002()).getDefeatedBosses();
        ServerConfig sc = new ServerConfig();
        sc.load();
        isSaveBossKiller_dynamic = sc.isSaveBossKiller();
    }

    private void onPlayerJoin(class_3222 player) {
        for (String lineOfInformation : defeated_bosses_on_server) {
            class_2540 originalBuf = new class_2540(Unpooled.buffer());
            originalBuf.method_10814(lineOfInformation);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)new class_2960(MOD_ID, "boss_defeated"), (class_2540)originalBuf);
        }
    }

    public static void removeBossFromDefeated_bosses_on_server(String value) {
        HashSet<String> defeated_bosses_on_serverCopy = new HashSet<String>();
        for (String boss : defeated_bosses_on_server) {
            String bossId = boss.split("#")[0];
            if (bossId.equals(value.split("#")[0])) continue;
            defeated_bosses_on_serverCopy.add(boss);
        }
        defeated_bosses_on_server.clear();
        defeated_bosses_on_server.addAll(defeated_bosses_on_serverCopy);
    }
}

