/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_642;

public class ClientDataSaver {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_FOLDER_NAME = "boss\u0421hecklist_data";
    private static final String JSON_FILE_NAME = "defeated_bosses.json";
    public static List<String> defeatedBosses_InWorld = new ArrayList<String>();
    public static List<String> defeatedBossesIds_InWorld = new ArrayList<String>();
    private static String worldKey = "not_initialized";

    public static void BossDefeated(String bossId, Boolean bool) {
        File dataFolder;
        if (worldKey.equals("not_initialized")) {
            ClientDataSaver.UpdateCurrentWorldKey();
        }
        if (!(dataFolder = new File(class_310.method_1551().field_1697, DATA_FOLDER_NAME + File.separator + worldKey)).exists() && !dataFolder.mkdirs()) {
            LoggerUtil.LOGGER.error("Failed to create data folder for world key: " + worldKey);
            return;
        }
        File jsonFile = new File(dataFolder, JSON_FILE_NAME);
        List<String> defeatedBosses = new ArrayList<String>();
        if (jsonFile.exists()) {
            try (FileReader reader = new FileReader(jsonFile);){
                Type listType = new TypeToken<List<String>>(){}.getType();
                defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
                if (defeatedBosses == null) {
                    defeatedBosses = new ArrayList();
                }
            }
            catch (IOException e) {
                LoggerUtil.LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (bool.booleanValue()) {
            if (!defeatedBosses.contains(bossId)) {
                defeatedBosses.add(bossId);
                try {
                    writer = new FileWriter(jsonFile);
                    try {
                        GSON.toJson(defeatedBosses, (Appendable)writer);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    LoggerUtil.LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else if (defeatedBosses.contains(bossId)) {
            defeatedBosses.remove(bossId);
            try {
                writer = new FileWriter(jsonFile);
                try {
                    GSON.toJson(defeatedBosses, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LoggerUtil.LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public static void BossDefeatedInWorld(String lineOfInformation) {
        String bossId = lineOfInformation.split("#")[0];
        Boolean bool = lineOfInformation.split("#", -1)[2].equals("true");
        ClientDataSaver.BossDefeated(bossId, bool);
        if (!defeatedBossesIds_InWorld.contains(bossId) && bool.booleanValue()) {
            defeatedBosses_InWorld.add(lineOfInformation);
            defeatedBossesIds_InWorld.add(bossId);
        }
        if (!bool.booleanValue()) {
            defeatedBosses_InWorld.remove(lineOfInformation);
            defeatedBossesIds_InWorld.remove(bossId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isBossDefeated(String bossId) {
        File jsonFile = new File(class_310.method_1551().field_1697, DATA_FOLDER_NAME + File.separator + worldKey + File.separator + JSON_FILE_NAME);
        if (!jsonFile.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
            if (defeatedBosses == null) return false;
            Boolean bl = defeatedBosses.contains(bossId);
            return bl;
        }
        catch (IOException e) {
            LoggerUtil.LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
        }
        return false;
    }

    public static void UpdateCurrentWorldKey() {
        class_642 serverData;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1542()) {
            worldKey = "singleplayer_" + minecraft.method_1576().method_27050(class_5218.field_24188).normalize().getFileName().toString();
            return;
        }
        class_634 clientPacketListener = minecraft.method_1562();
        if (clientPacketListener != null && (serverData = clientPacketListener.method_45734()) != null) {
            worldKey = "multiplayer_" + serverData.field_3761.replace(":", "_");
            return;
        }
        worldKey = "INVALID_WORLD_KEY";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int defeatedBossesCount() {
        File jsonFile = new File(class_310.method_1551().field_1697, DATA_FOLDER_NAME + File.separator + worldKey + File.separator + JSON_FILE_NAME);
        if (!jsonFile.exists()) {
            return 0;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
            if (defeatedBosses == null) return 0;
            int n = defeatedBosses.size();
            return n;
        }
        catch (IOException e) {
            LoggerUtil.LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
        }
        return 0;
    }

    public static String whoKiller(String bossId) {
        for (String lineOfInformation : defeatedBosses_InWorld) {
            String bossIdFromList = lineOfInformation.split("#")[0];
            if (!bossId.equals(bossIdFromList)) continue;
            if (lineOfInformation.split("#").length == 1) {
                return "";
            }
            return lineOfInformation.split("#")[1];
        }
        return "ERROR";
    }
}

