/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class JsonConfigManager<T> {
    private final Class<T> configClass;
    private final Path configPath;
    private final Gson gson;
    private T configInstance;

    protected JsonConfigManager(Class<T> configClass, Path configPath) {
        this.configClass = configClass;
        this.configPath = configPath;
        this.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    }

    public void load() {
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                this.saveDefault();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
                this.configInstance = this.gson.fromJson(new JsonReader((Reader)reader), this.configClass);
            }
            if (this.configInstance == null) {
                throw new IOException("Config parsed to null (corrupted JSON?)");
            }
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("[CONFIG] Failed to load " + String.valueOf(this.configPath.getFileName()) + ": " + e.getMessage());
            this.backupCorruptedFile();
            this.saveDefault();
        }
    }

    public T get() {
        if (this.configInstance == null) {
            this.load();
        }
        return this.configInstance;
    }

    public void save() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                this.gson.toJson(this.configInstance, (Appendable)writer);
            }
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("[CONFIG] Failed to save config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveDefault() {
        try {
            this.configInstance = this.getDefaultConfig();
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                this.gson.toJson(this.configInstance, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void backupCorruptedFile() {
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
                Path backup = this.configPath.resolveSibling(String.valueOf(this.configPath.getFileName()) + ".broken_" + timestamp + ".bak");
                Files.move(this.configPath, backup, StandardCopyOption.REPLACE_EXISTING);
                LoggerUtil.LOGGER.info("[CONFIG] Corrupted config renamed to: " + String.valueOf(backup.getFileName()));
            }
        }
        catch (IOException ex) {
            LoggerUtil.LOGGER.error("[CONFIG] Failed to backup corrupted file: " + ex.getMessage());
        }
    }

    protected abstract T getDefaultConfig();
}

