/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;

public final class ServerBossIdsLoader {
    private static final class_2960 JSON_RL = new class_2960("boss_checklist", "server_bosses_ids.json");
    private static final Gson GSON = new Gson();
    public static final Set<String> server_bosses_ids_list = new HashSet<String>();
    public static final Set<String> server_bosses_ids_list_only_loaded_mods = new HashSet<String>();

    public static void load(MinecraftServer server) {
        server_bosses_ids_list.clear();
        class_3300 rm = server.method_34864();
        try {
            for (class_3298 res : rm.method_14489(JSON_RL)) {
                try {
                    BufferedReader reader = res.method_43039();
                    try {
                        JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (root == null) continue;
                        if (root.isJsonArray()) {
                            for (JsonElement el : root.getAsJsonArray()) {
                                String id;
                                if (el.isJsonObject()) {
                                    String id2;
                                    JsonObject obj = el.getAsJsonObject();
                                    if (!obj.has("id") || obj.get("id").isJsonNull() || (id2 = obj.get("id").getAsString().trim()).isEmpty()) continue;
                                    server_bosses_ids_list.add(id2);
                                    continue;
                                }
                                if (!el.isJsonPrimitive() || (id = el.getAsString().trim()).isEmpty()) continue;
                                server_bosses_ids_list.add(id);
                            }
                            continue;
                        }
                        LoggerUtil.LOGGER.warn("Unexpected JSON type for server_bosses_ids in " + res.method_14480());
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.LOGGER.warn("Failed to read server_bosses_ids.json from " + res.method_14480(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtil.LOGGER.error("Unexpected error loading server boss ids", (Throwable)ex);
        }
        LoggerUtil.LOGGER.info("Loaded server boss ids: " + server_bosses_ids_list.size());
        for (String bossId : server_bosses_ids_list) {
            if (!Platform.isModLoaded((String)bossId.split(":")[0])) continue;
            server_bosses_ids_list_only_loaded_mods.add(bossId);
        }
    }
}

