/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.client.gui.BossChecklistScreen;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import com.yori3o.boss_checklist.utils.TextUtil;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class BossRegistry {
    private static final ClientDataSaver DATA_SAVER = new ClientDataSaver();
    private static final Map<String, BossData> BOSSES = new LinkedHashMap<String, BossData>();
    public static List<BossData> bossDataList;
    private static final Gson GSON;
    public static List<Component> bossNames;
    public static boolean bossNamesListLoaded;

    public static void load() {
        bossNamesListLoaded = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91098_() == null) {
            LoggerUtil.LOGGER.warn("ResourceManager not ready yet!");
            return;
        }
        BOSSES.clear();
        try {
            ResourceManager resourceManager = mc.m_91098_();
            ResourceLocation loc = new ResourceLocation("boss_checklist", "bosses.json");
            ArrayList allBosses = new ArrayList();
            for (Resource res : resourceManager.m_213829_(loc)) {
                try {
                    BufferedReader reader = res.m_215508_();
                    try {
                        Type listType = new TypeToken<List<BossData>>(){}.getType();
                        List partial = (List)GSON.fromJson((Reader)reader, listType);
                        if (partial != null) {
                            allBosses.addAll(partial);
                        }
                        LoggerUtil.LOGGER.info("Loaded bosses.json from " + res.m_215506_());
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LoggerUtil.LOGGER.warn("Failed to read bosses.json from " + res.m_215506_(), (Throwable)e);
                }
            }
            LinkedHashMap<String, BossData> merged = new LinkedHashMap<String, BossData>();
            for (BossData data : allBosses) {
                Boolean replace = Boolean.TRUE.equals(data.replace);
                BossData existing = (BossData)merged.get(data.getId());
                if (existing == null || replace.booleanValue()) {
                    merged.put(data.getId(), data);
                    continue;
                }
                if (existing.replace.booleanValue()) continue;
                BossRegistry.mergeFields(existing, data);
            }
            bossDataList = new ArrayList(merged.values());
            bossDataList.forEach(BossData::applyDefaults);
            bossDataList.sort(Comparator.comparingDouble(BossData::getPosition));
            for (BossData data : bossDataList) {
                if (!Platform.isModLoaded((String)data.getModId())) continue;
                String bossId = data.getId();
                if (DATA_SAVER.isBossDefeated(bossId).booleanValue()) {
                    data.SetDefeated(true);
                    ClientDataSaver.alreadyAnimated.add(bossId);
                } else {
                    data.SetDefeated(false);
                }
                BOSSES.put(bossId, data);
            }
            LoggerUtil.LOGGER.info("Loaded bosses: " + String.valueOf(BOSSES.keySet()));
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("An unexpected error occurred while loading bosses!", (Throwable)e);
        }
    }

    public static BossData get(String id) {
        return BOSSES.get(id);
    }

    public static Collection<BossData> all() {
        return BOSSES.values();
    }

    public static Set<String> allIds() {
        return BOSSES.keySet();
    }

    private static void mergeFields(BossData base, BossData addition) {
        if (base == null || addition == null) {
            return;
        }
        try {
            for (Field field : BossData.class.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.getName().equals("replace")) continue;
                Object addValue = field.get(addition);
                Object baseValue = field.get(base);
                if (addValue == null) continue;
                if (List.class.isAssignableFrom(field.getType())) {
                    List addList = (List)addValue;
                    if (addList.isEmpty()) continue;
                    if (baseValue == null) {
                        field.set(base, new ArrayList(addList));
                        continue;
                    }
                    ((List)baseValue).addAll(addList);
                    continue;
                }
                field.set(base, addValue);
            }
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("Error when merging BossData fields", (Throwable)e);
        }
    }

    public static void updateBossNamesList() {
        bossNamesListLoaded = true;
        bossNames.clear();
        for (BossData b : BOSSES.values().stream().toList()) {
            if (BossChecklistClient.isProgressionMode_dynamic && !ClientDataSaver.defeatedBossesIds_InWorld.contains(b.getId())) {
                bossNames.add((Component)Component.m_237113_((String)"???"));
                continue;
            }
            String translated = Component.m_237115_((String)("boss_checklist.boss." + b.getId().replace(":", "_"))).getString();
            String truncated = TextUtil.truncateText(translated, BossChecklistScreen.maxTextWidth).getString();
            bossNames.add((Component)Component.m_237113_((String)truncated));
        }
    }

    static {
        GSON = new Gson();
        bossNames = new ArrayList<Component>();
        bossNamesListLoaded = false;
    }
}

