/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.client.gui.BossInfoScreen;
import com.yori3o.boss_checklist.client.gui.ConfigScreen;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.client.gui.CustomPageButton;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class BossChecklistScreen
extends Screen {
    private static final ClientDataSaver DATA_SAVER = new ClientDataSaver();
    private static final ResourceLocation bar_background = new ResourceLocation("boss_checklist", "textures/gui/white_background.png");
    private static final ResourceLocation bar_progress = new ResourceLocation("boss_checklist", "textures/gui/white_progress.png");
    private static final ResourceLocation BOOKMARK_SETTINGS = new ResourceLocation("boss_checklist", "textures/gui/bookmark_settings.png");
    private final int BOOKMARK_SETTINGS_x = 387;
    private final int BOOKMARK_SETTINGS_y = 65;
    private static final ResourceLocation background_texture = new ResourceLocation("boss_checklist", "textures/gui/boss_book.png");
    private static final int ELEMENTS_PER_PAGE = 7;
    private int currentSpread = 0;
    private int totalSpreads;
    public static int maxTextWidth = 95;
    private List<CustomCheckbox> currentCheckboxes = new ArrayList<CustomCheckbox>();
    private CustomPageButton nextButton;
    private CustomPageButton prevButton;
    private int leftPage;
    private int rightPage;
    private boolean noBossesLoaded = false;
    private boolean ChecklistAreLoaded = false;
    private boolean exitFromSettings;
    private List<Component> bossNames = new ArrayList<Component>();
    private List<String> bossIds = new ArrayList<String>();
    private int defeatedCount;
    private int totalCount;
    private float percent;

    public BossChecklistScreen(Boolean exitFromSettings) {
        super((Component)Component.m_237113_((String)"Checklist"));
        this.exitFromSettings = exitFromSettings;
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.exitFromSettings) {
            BossRegistry.updateBossNamesList();
            this.bossNames = BossRegistry.bossNames;
        }
        if (!BossRegistry.bossNamesListLoaded) {
            BossRegistry.updateBossNamesList();
        }
        if (!this.ChecklistAreLoaded) {
            this.bossIds.addAll(BossRegistry.all().stream().map(BossData::getId).toList());
            this.bossNames = BossRegistry.bossNames;
            this.ChecklistAreLoaded = true;
        }
        this.updateCounts();
        this.createPageButtons();
        this.updatePage();
    }

    private void updateCounts() {
        this.defeatedCount = DATA_SAVER.defeatedBossesCount();
        this.totalCount = this.bossIds.size();
        this.percent = this.totalCount > 0 ? (float)this.defeatedCount / (float)this.totalCount : 0.0f;
    }

    private void createPageButtons() {
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        double totalPages = Math.ceil((double)this.bossNames.size() / 7.0);
        this.totalSpreads = (int)Math.ceil(totalPages / 2.0);
        this.prevButton = new CustomPageButton(bookX + 138, bookY + 190, true, () -> {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
            }
        });
        this.nextButton = new CustomPageButton(bookX + 350, bookY + 190, false, () -> {
            if (this.currentSpread < this.totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
            }
        });
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
    }

    private void updatePage() {
        if (this.bossNames.isEmpty()) {
            LoggerUtil.LOGGER.warn("No bosses loaded at checklist! - Resources are empty or invalid.");
            this.prevButton.f_93624_ = false;
            this.nextButton.f_93624_ = false;
            this.noBossesLoaded = true;
            return;
        }
        for (CustomCheckbox cb : this.currentCheckboxes) {
            this.m_169411_((GuiEventListener)cb);
        }
        this.currentCheckboxes.clear();
        double totalPages = Math.ceil((double)this.bossNames.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        int fromIndex = this.currentSpread * 14;
        int toIndex = Math.min(fromIndex + 14, this.bossNames.size());
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        int leftX = bookX + 134;
        int rightX = bookX + 266;
        int startY = bookY + 56;
        for (int i = fromIndex; i < toIndex; ++i) {
            String boss = this.bossNames.get(i).getString();
            String bossId = this.bossIds.get(i);
            int localIndex = i - fromIndex;
            int x = localIndex < 7 ? leftX : rightX;
            int y = startY + localIndex % 7 * 18;
            BossData data = BossRegistry.get(bossId);
            boolean isThisBossDefeated = DATA_SAVER.isBossDefeated(bossId);
            boolean isFresh = false;
            if (isThisBossDefeated && data.isFresh().booleanValue()) {
                isFresh = true;
            }
            CustomCheckbox cb = new CustomCheckbox(x, y, (Component)Component.m_237113_((String)boss), isThisBossDefeated, true, isFresh, checked -> {
                data.SetFresh(false);
                ClientDataSaver.BossDefeated(bossId, checked);
                this.updateCounts();
                if (BossChecklistClient.isAnimationEnabled_dynamic) {
                    if (checked.booleanValue()) {
                        ClientDataSaver.alreadyAnimated.add(bossId);
                    } else {
                        ClientDataSaver.alreadyAnimated.remove(bossId);
                    }
                }
            }, () -> {
                Minecraft.m_91087_().m_91152_((Screen)new BossInfoScreen(new BossChecklistScreen(false), bossId));
                data.SetFresh(false);
            });
            if (BossChecklistClient.isAnimationEnabled_dynamic && isThisBossDefeated && !ClientDataSaver.alreadyAnimated.contains(bossId)) {
                ClientDataSaver.alreadyAnimated.add(bossId);
                cb.isAnimating = true;
                cb.animationPlayed = false;
                cb.animationStartTime = System.currentTimeMillis();
            }
            this.m_142416_((GuiEventListener)cb);
            this.currentCheckboxes.add(cb);
        }
        this.prevButton.f_93624_ = this.currentSpread > 0;
        this.nextButton.f_93624_ = this.currentSpread < totalSpreads - 1;
        this.leftPage = this.currentSpread * 2 + 1;
        this.rightPage = this.currentSpread * 2 + 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        guiGraphics.m_280163_(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.m_280163_(bar_background, bookX + 165, bookY + 29, 0.0f, 0.0f, 182, 5, 182, 5);
        guiGraphics.m_280163_(bar_progress, bookX + 165, bookY + 29, 0.0f, 0.0f, (int)(this.percent * 182.0f), 5, 182, 5);
        guiGraphics.m_280163_(BOOKMARK_SETTINGS, bookX + 387, bookY + 65, 0.0f, 0.0f, 12, 22, 12, 22);
        guiGraphics.m_280056_(this.f_96547_, this.defeatedCount + " / " + this.totalCount, (this.f_96543_ - Minecraft.m_91087_().f_91062_.m_92895_(this.defeatedCount + " / " + this.totalCount)) / 2, bookY + 20, 0xFFFFFF, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.noBossesLoaded) {
            guiGraphics.m_280056_(this.f_96547_, "No bosses loaded!", bookX + 140, bookY + 53, 0, false);
        } else {
            guiGraphics.m_280056_(this.f_96547_, String.valueOf(this.leftPage), bookX + 187, bookY + 195, 3026218, false);
            guiGraphics.m_280056_(this.f_96547_, String.valueOf(this.rightPage), bookX + 320, bookY + 195, 3026218, false);
        }
        if (mouseX >= bookX + 387 && mouseX < bookX + 387 + 12 && mouseY >= bookY + 65 && mouseY < bookY + 65 + 22) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Component.m_237115_((String)"gui.boss_checklist.settings").getString()), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)((this.f_96543_ - 512) / 2 + 387) && mouseX <= (double)((this.f_96543_ - 512) / 2 + 387 + 11) && mouseY >= (double)((this.f_96544_ - 256) / 2 + 65) && mouseY <= (double)((this.f_96544_ - 256) / 2 + 65 + 22)) {
            this.f_96541_.m_91152_((Screen)new ConfigScreen(new BossChecklistScreen(true)));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistClient.OPEN_CHECKLIST.m_90832_(keyCode, scanCode)) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        if (keyCode == 263) {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.currentSpread < this.totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

