/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CustomButton
extends Button {
    private final ResourceLocation normalTex;
    private final ResourceLocation hoverTex;
    private final ResourceLocation pressedTex;
    ResourceLocation tex;
    private boolean pressedFlag = false;

    public CustomButton(int x, int y, int width, int height, Component label, ResourceLocation normalTex, ResourceLocation hoverTex, ResourceLocation pressedTex, Runnable onPressAction) {
        super(x, y, width, height, label, b -> onPressAction.run(), Button.DEFAULT_NARRATION);
        this.normalTex = normalTex;
        this.hoverTex = hoverTex;
        this.pressedTex = pressedTex;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tex = this.pressedFlag ? this.pressedTex : (this.isHovered ? this.hoverTex : this.normalTex);
        guiGraphics.blit(this.tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        int textWidth = Minecraft.getInstance().font.width((FormattedText)this.getMessage());
        int textX = this.getX() + (this.width - textWidth) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), textX, textY, 0xFFFFFF, false);
    }

    public void onPress() {
        this.pressedFlag = true;
        super.onPress();
    }

    public void onRelease(double mouseX, double mouseY) {
        this.pressedFlag = false;
    }
}

