/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CustomButton
extends Button {
    private final ResourceLocation normalTex;
    private final ResourceLocation hoverTex;
    private final ResourceLocation pressedTex;
    private final ResourceLocation overlayTex;
    private final int overlayWidth;
    private final int overlayHeight;
    ResourceLocation tex;
    private boolean pressedFlag = false;

    public CustomButton(int x, int y, int width, int height, int overlayWidth, int overlayHeight, Component label, ResourceLocation normalTex, ResourceLocation hoverTex, ResourceLocation pressedTex, ResourceLocation overlayTex, Runnable onPressAction) {
        super(x, y, width, height, label, b -> onPressAction.run(), Button.DEFAULT_NARRATION);
        this.normalTex = normalTex;
        this.hoverTex = hoverTex;
        this.pressedTex = pressedTex;
        this.overlayTex = overlayTex;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tex = this.pressedFlag ? this.pressedTex : (this.isHovered ? this.hoverTex : this.normalTex);
        RenderSystem.enableBlend();
        guiGraphics.blit(this.tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (this.overlayTex != null) {
            guiGraphics.blit(this.overlayTex, this.getX() - (int)(0.5 * (double)(this.overlayWidth - this.width)), this.getY() - (int)(0.5 * (double)(this.overlayHeight - this.height)), 0.0f, 0.0f, this.overlayWidth, this.overlayHeight, this.overlayWidth, this.overlayHeight);
        }
        int textWidth = Minecraft.getInstance().font.width((FormattedText)this.getMessage());
        int textX = this.getX() + (this.width - textWidth) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), textX, textY, 0xFFFFFF, false);
    }

    public void onPress() {
        this.pressedFlag = true;
        super.onPress();
    }

    public void onRelease(double mouseX, double mouseY) {
        this.pressedFlag = false;
    }
}

