/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public final class ServerBossIdsLoader {
    private static final ResourceLocation JSON_RL = new ResourceLocation("boss_checklist", "server_bosses_ids.json");
    private static final Gson GSON = new Gson();
    public static final Set<String> server_bosses_ids_list = new HashSet<String>();
    public static final Set<String> server_bosses_ids_list_only_loaded_mods = new HashSet<String>();

    public static void load(ResourceManager rm) {
        server_bosses_ids_list_only_loaded_mods.clear();
        server_bosses_ids_list.clear();
        try {
            for (Resource res : rm.getResourceStack(JSON_RL)) {
                try {
                    BufferedReader reader = res.openAsReader();
                    try {
                        JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (root == null) continue;
                        if (root.isJsonArray()) {
                            for (JsonElement el : root.getAsJsonArray()) {
                                String id;
                                if (el.isJsonObject()) {
                                    String id2;
                                    JsonObject obj = el.getAsJsonObject();
                                    if (!obj.has("id") || obj.get("id").isJsonNull() || (id2 = obj.get("id").getAsString().trim()).isEmpty()) continue;
                                    server_bosses_ids_list.add(id2);
                                    continue;
                                }
                                if (!el.isJsonPrimitive() || (id = el.getAsString().trim()).isEmpty()) continue;
                                server_bosses_ids_list.add(id);
                            }
                            continue;
                        }
                        LoggerUtil.LOGGER.warn("Unexpected JSON type for server_bosses_ids in " + res.sourcePackId());
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.LOGGER.warn("Failed to read server_bosses_ids.json from " + res.sourcePackId(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtil.LOGGER.error("Unexpected error loading server boss ids!", (Throwable)ex);
        }
        for (String bossId : server_bosses_ids_list) {
            if (!Platform.isModLoaded((String)bossId.split(":")[0])) continue;
            server_bosses_ids_list_only_loaded_mods.add(bossId);
        }
        LoggerUtil.LOGGER.info("Number of loaded bosses on the server: " + server_bosses_ids_list_only_loaded_mods.size());
    }
}

